/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.container.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;
import org.openstack4j.model.container.AppContainerLog;
import org.openstack4j.model.container.builder.AppContainerLogBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ZunAppContainerLog
implements AppContainerLog {
    String containerId;
    Boolean stdout;
    Boolean stderr;
    Boolean timestamps;
    String tail;
    String since;

    public static AppContainerLogBuilder builder() {
        return new ConcreteLogsParametersBuilder();
    }

    @Override
    public String containerId() {
        return this.containerId;
    }

    @Override
    public Boolean getStdout() {
        return this.stdout;
    }

    @Override
    public Boolean getStderr() {
        return this.stderr;
    }

    @Override
    public Boolean getTimestamps() {
        return this.timestamps;
    }

    @Override
    public String getTail() {
        return this.tail;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public Map<String, Object> getQueryParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.stdout != null) {
            params.put("stdout", this.stdout);
        }
        if (this.stderr != null) {
            params.put("stderr", this.stderr);
        }
        if (this.timestamps != null) {
            params.put("timestamps", this.timestamps);
        }
        if (this.tail != null) {
            params.put("tail", this.tail);
        }
        if (this.since != null) {
            params.put("since", this.since);
        }
        return params;
    }

    public AppContainerLogBuilder toBuilder() {
        return new ConcreteLogsParametersBuilder(this);
    }

    public static class ConcreteLogsParametersBuilder
    implements AppContainerLogBuilder {
        ZunAppContainerLog model = new ZunAppContainerLog();

        public ConcreteLogsParametersBuilder() {
        }

        public ConcreteLogsParametersBuilder(ZunAppContainerLog model) {
            this.model = model;
        }

        @Override
        public AppContainerLogBuilder containerId(String var1) {
            this.model.containerId = var1;
            return this;
        }

        @Override
        public AppContainerLogBuilder stdout(boolean val) {
            this.model.stdout = val;
            return this;
        }

        @Override
        public AppContainerLogBuilder stderr(boolean val) {
            this.model.stderr = val;
            return this;
        }

        @Override
        public AppContainerLogBuilder timestamps(boolean val) {
            this.model.timestamps = val;
            return this;
        }

        @Override
        public AppContainerLogBuilder tail(int lines) {
            this.model.tail = String.valueOf(lines);
            return this;
        }

        @Override
        public AppContainerLogBuilder tailAll() {
            this.model.tail = "all";
            return this;
        }

        @Override
        public AppContainerLogBuilder since(String timestampOrDuration) {
            this.model.since = timestampOrDuration;
            return this;
        }

        public AppContainerLog build() {
            return this.model;
        }

        public AppContainerLogBuilder from(AppContainerLog in) {
            this.model = (ZunAppContainerLog)in;
            return this;
        }
    }
}

