/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.container.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.container.AppContainerNetwork;
import org.openstack4j.model.container.builder.AppContainerNetworkBuilder;
import org.openstack4j.openstack.common.ListResult;

public class ZunAppContainerNetwork
implements AppContainerNetwork {
    @JsonProperty(value="port_id")
    private String portId;
    @JsonProperty(value="net_id")
    private String netId;
    @JsonProperty(value="fixed_ips")
    private List<AppContainerSubnet> fixedIps;

    public static AppContainerNetworkBuilder builder() {
        return new createnAppContainerNetworkBuilder();
    }

    public AppContainerNetworkBuilder toBuilder() {
        return new createnAppContainerNetworkBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("portId", (Object)this.portId).add("netId", (Object)this.netId).add("fixedIps", this.fixedIps).toString();
    }

    @Override
    public String getPortId() {
        return this.portId;
    }

    @Override
    public String getNetId() {
        return this.netId;
    }

    @Override
    public List<AppContainerSubnet> getFixedIps() {
        return this.fixedIps;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class AppContainerNetworks
    extends ListResult<ZunAppContainerNetwork> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="networks")
        private List<ZunAppContainerNetwork> networks;

        protected List<ZunAppContainerNetwork> value() {
            return this.networks;
        }
    }

    public static class AppContainerSubnet {
        @JsonProperty(value="subnet_id")
        public String subneId;
        @JsonProperty(value="ip_address")
        public String ipAddress;
        public Integer version;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("ip_address", (Object)this.ipAddress).add("subnet_id", (Object)this.subneId).add("version", (Object)this.version).toString();
        }
    }

    public static class createnAppContainerNetworkBuilder
    implements AppContainerNetworkBuilder {
        ZunAppContainerNetwork model;

        public createnAppContainerNetworkBuilder() {
            this(new ZunAppContainerNetwork());
        }

        public createnAppContainerNetworkBuilder(ZunAppContainerNetwork model) {
            this.model = model;
        }

        @Override
        public AppContainerNetworkBuilder portId(String portId) {
            this.model.portId = portId;
            return this;
        }

        @Override
        public AppContainerNetworkBuilder netId(String netId) {
            this.model.netId = netId;
            return this;
        }

        @Override
        public AppContainerNetworkBuilder fixedIps(List<AppContainerSubnet> fixedIps) {
            this.model.fixedIps = fixedIps;
            return this;
        }

        public AppContainerNetwork build() {
            return this.model;
        }

        public AppContainerNetworkBuilder from(AppContainerNetwork in) {
            this.model = (ZunAppContainerNetwork)in;
            return this;
        }
    }
}

