/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.container.internal;

import com.google.common.base.Preconditions;
import org.openstack4j.api.container.AppContainerQuotaService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.container.AppContainerQuotaSet;
import org.openstack4j.model.container.AppContainerQuotaSetUsage;
import org.openstack4j.openstack.container.domain.ZunAppContainerQuotaSet;
import org.openstack4j.openstack.container.domain.ZunAppContainerQuotaSetUsage;
import org.openstack4j.openstack.container.internal.BaseAppcontainerServices;

public class AppContainerQuotaServiceImpl
extends BaseAppcontainerServices
implements AppContainerQuotaService {
    @Override
    public AppContainerQuotaSet get(String projectId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"Project cannot be null");
        return (AppContainerQuotaSet)this.get(ZunAppContainerQuotaSet.class, new String[]{this.uri("/quotas/%s", new Object[]{projectId})}).execute();
    }

    @Override
    public AppContainerQuotaSetUsage getUsage(String projectId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"Project cannot be null");
        return (AppContainerQuotaSetUsage)this.get(ZunAppContainerQuotaSetUsage.class, new String[]{this.uri("/quotas/%s", new Object[]{projectId})}).param("usages", (Object)true).execute();
    }

    @Override
    public AppContainerQuotaSet getDefault(String projectId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"Project cannot be null");
        return (AppContainerQuotaSet)this.get(ZunAppContainerQuotaSetUsage.class, new String[]{this.uri("/quotas/%s/defaults", new Object[]{projectId})}).execute();
    }

    @Override
    public AppContainerQuotaSet update(String projectId, AppContainerQuotaSet quota) {
        Preconditions.checkNotNull((Object)projectId, (Object)"Project cannot be null");
        Preconditions.checkNotNull((Object)quota, (Object)"Quota cannot be null");
        return (AppContainerQuotaSet)this.put(ZunAppContainerQuotaSetUsage.class, new String[]{this.uri("/quotas/%s", new Object[]{projectId})}).entity((ModelEntity)quota).execute();
    }

    @Override
    public ActionResponse delete(String projectId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"Project cannot be null");
        return (ActionResponse)this.deleteWithResponse(new String[]{this.uri("/quotas/%s", new Object[]{projectId})}).execute();
    }
}

