/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.container.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openstack4j.api.container.AppContainerService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.container.AppContainer;
import org.openstack4j.model.container.AppContainerAction;
import org.openstack4j.model.container.AppContainerCommit;
import org.openstack4j.model.container.AppContainerCreate;
import org.openstack4j.model.container.AppContainerExecResult;
import org.openstack4j.model.container.AppContainerLog;
import org.openstack4j.model.container.AppContainerNetwork;
import org.openstack4j.model.container.AppContainerStats;
import org.openstack4j.model.container.AppContainerUpdate;
import org.openstack4j.model.container.AttachResponse;
import org.openstack4j.model.container.NetworkAttach;
import org.openstack4j.model.container.NetworkDetach;
import org.openstack4j.openstack.container.domain.ZunAppContainer;
import org.openstack4j.openstack.container.domain.ZunAppContainerAction;
import org.openstack4j.openstack.container.domain.ZunAppContainerCommit;
import org.openstack4j.openstack.container.domain.ZunAppContainerExecResult;
import org.openstack4j.openstack.container.domain.ZunAppContainerNetwork;
import org.openstack4j.openstack.container.domain.ZunAppContainerUpdate;
import org.openstack4j.openstack.container.domain.ZunAttachResponse;
import org.openstack4j.openstack.container.domain.ZunContainerStats;
import org.openstack4j.openstack.container.internal.AppContainerFileImpl;
import org.openstack4j.openstack.container.internal.BaseAppcontainerServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class AppContainerServiceImpl
extends BaseAppcontainerServices
implements AppContainerService {
    @Override
    public List<? extends AppContainer> list() {
        return this.list(null);
    }

    @Override
    public List<? extends AppContainer> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation req = this.get(ZunAppContainer.ZunContainers.class, new String[]{this.uri("containers", new Object[0])});
        if (filteringParams != null && !filteringParams.isEmpty()) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), (Object)entry.getValue());
            }
        }
        return ((ZunAppContainer.ZunContainers)((Object)req.execute())).getList();
    }

    @Override
    public AppContainer get(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (AppContainer)this.get(ZunAppContainer.class, new String[]{this.uri("/containers/%s", new Object[]{containerId})}).execute();
    }

    @Override
    public AppContainer create(AppContainerCreate container) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)container.getImage(), (Object)"Image must be set in ContainerCreate config");
        return (AppContainer)this.post(ZunAppContainer.class, new String[]{this.uri("containers", new Object[0])}).header("OpenStack-API-Version", (Object)"container 1.39").entity((ModelEntity)container).execute();
    }

    @Override
    public ActionResponse delete(String containerId, boolean isForce) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.deleteWithResponse(new String[]{this.uri("/containers/%s", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("force", (Object)isForce).execute();
    }

    @Override
    public ActionResponse delete(String containerId, boolean force, boolean stop) {
        Preconditions.checkNotNull((Object)containerId);
        HashMap<String, String> params = new HashMap<String, String>();
        if (force) {
            params.put("force", "True");
        }
        if (stop) {
            params.put("stop", "True");
        }
        return (ActionResponse)this.deleteWithResponse(new String[]{this.uri("%s/%s", new Object[]{"containers", containerId})}).params(params).execute();
    }

    @Override
    public AppContainerStats stats(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (AppContainerStats)this.get(ZunContainerStats.class, new String[]{this.uri("%s/%s/stats", new Object[]{"containers", containerId})}).execute();
    }

    @Override
    public ActionResponse start(String containerId) {
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/start", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse stop(String containerId) {
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/stop", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse pause(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/pause", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse unpause(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/unpause", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse kill(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/kill", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute();
    }

    @Override
    public List<? extends AppContainerNetwork> networkList(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return ((ZunAppContainerNetwork.AppContainerNetworks)((Object)this.get(ZunAppContainerNetwork.AppContainerNetworks.class, new String[]{this.uri("/containers/%s/network_list", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute())).getList();
    }

    @Override
    public ActionResponse restart(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/reboot", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse rebuild(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/rebuild", new Object[]{containerId})}).execute();
    }

    @Override
    public String logs(String containerId, AppContainerLog params) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)params);
        BaseOpenStackService.Invocation req = this.get(JsonNode.class, new String[]{this.uri("/containers/%s/logs", new Object[]{params.containerId()})});
        params.getQueryParameters().forEach((k, v) -> req.param(k, (Object)String.valueOf(v)));
        return ((JsonNode)req.execute()).asText();
    }

    @Override
    public List<? extends AppContainerAction> listActions(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return ((ZunAppContainerAction.AppContainerActions)((Object)this.get(ZunAppContainerAction.AppContainerActions.class, new String[]{this.uri("/containers/%s/container_actions", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute())).getList();
    }

    @Override
    public AppContainerAction actions(String containerId, String requestId) {
        Preconditions.checkNotNull((Object)containerId);
        return (AppContainerAction)this.get(AppContainerAction.class, new String[]{this.uri("/containers/%s/container_actions/%s", new Object[]{containerId, requestId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute();
    }

    @Override
    public AppContainerExecResult executeCommand(String containerId, String command) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)command);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", command);
        params.put("run", true);
        AppContainerExecResult result = (AppContainerExecResult)this.post(ZunAppContainerExecResult.class, new String[]{this.uri("/containers/%s/execute", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").params(params).execute();
        return Objects.isNull(result) ? new ZunAppContainerExecResult("Not Found", 404) : result;
    }

    @Override
    public String attach(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        AttachResponse response = (AttachResponse)this.get(ZunAttachResponse.class, new String[]{this.uri("%s/%s/attach", new Object[]{"containers", containerId})}).execute();
        return response != null ? response.getUrl() : null;
    }

    @Override
    public String commit(AppContainerCommit appContainerCommit) {
        Preconditions.checkNotNull((Object)appContainerCommit);
        Preconditions.checkNotNull((Object)appContainerCommit.getRepository(), (Object)"Repository must be provided for commit");
        ImmutableMap params = ImmutableMap.of((Object)"repository", (Object)appContainerCommit.getRepository(), (Object)"tag", (Object)appContainerCommit.getTag());
        BaseOpenStackService.Invocation req = this.post(ZunAppContainerCommit.commitResult.class, new String[]{this.uri("containers/%s/commit", new Object[]{appContainerCommit.getContainerId()})}).contentType("application/json-patch+json");
        params.forEach((k, v) -> req.param(k, (Object)String.valueOf(v)));
        return ((ZunAppContainerCommit.commitResult)req.execute()).getId();
    }

    @Override
    public AppContainer rename(String containerId, String newName) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)newName);
        AppContainerUpdate update = (AppContainerUpdate)ZunAppContainerUpdate.builder().name(newName).build();
        return this.update(containerId, update);
    }

    @Override
    public AppContainer update(String containerId, AppContainerUpdate options) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)options);
        return (AppContainer)this.patch(ZunAppContainer.class, new String[]{this.uri("%s/%s", new Object[]{"containers", containerId})}).entity((ModelEntity)options).execute();
    }

    @Override
    public ActionResponse networkAttach(String containerId, NetworkAttach options) {
        Preconditions.checkNotNull((Object)options.getNetwork());
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)options.getNetwork())) {
            params.put("network", options.getNetwork());
        }
        if (StringUtils.isNotBlank((CharSequence)options.getPort())) {
            params.put("port", options.getPort());
        }
        if (StringUtils.isNotBlank((CharSequence)options.getFixedIp())) {
            params.put("fixed_ip", options.getFixedIp());
        }
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("containers/%s/network_attach", new Object[]{containerId})}).header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json").header("OpenStack-API-Version", (Object)"container 1.39").params(params).execute();
    }

    @Override
    public ActionResponse networkDetach(String containerId, NetworkDetach networkDetach) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)networkDetach.getNetwork())) {
            params.put("network", networkDetach.getNetwork());
        }
        if (StringUtils.isNotBlank((CharSequence)networkDetach.getPort())) {
            params.put("port", networkDetach.getPort());
        }
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("containers/%s/network_detach", new Object[]{containerId})}).header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json").header("OpenStack-API-Version", (Object)"container 1.39").params(params).execute();
    }

    @Override
    public ActionResponse writeFile(String containerId, String containerPath, String fileName, String fileContent) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)containerPath);
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)fileContent);
        String base64DataJson = null;
        try {
            base64DataJson = AppContainerFileImpl.getTarFileBase64Json(fileName, fileContent, false);
        }
        catch (IOException var8) {
            var8.printStackTrace();
        }
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/put_archive", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("path", (Object)containerPath).json(base64DataJson).execute();
    }

    @Override
    public ActionResponse writeFile(String containerId, String containerPath, String fileName, String fileContent, Boolean isBase64) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)containerPath);
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)fileContent);
        Preconditions.checkNotNull((Object)isBase64);
        String base64DataJson = null;
        try {
            base64DataJson = AppContainerFileImpl.getTarFileBase64Json(fileName, fileContent, isBase64);
        }
        catch (IOException var8) {
            var8.printStackTrace();
        }
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/put_archive", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("path", (Object)containerPath).json(base64DataJson).execute();
    }

    @Override
    public String readFile(String containerId, String containerPath) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)containerPath);
        Map result = (Map)this.get(Map.class, new String[]{this.uri("/containers/%s/get_archive", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("path", (Object)containerPath).execute();
        String fileContent = null;
        try {
            fileContent = AppContainerFileImpl.getFileContent((String)result.get("data"));
        }
        catch (IOException var6) {
            var6.printStackTrace();
        }
        return fileContent;
    }
}

