/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gateway.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.openstack4j.model.gateway.Device;
import org.openstack4j.model.gateway.L2Gateway;
import org.openstack4j.model.gateway.builder.L2GatewayBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.gateway.domain.GatewayDevice;

public class GatewayL2Gateway
implements L2Gateway {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="devices")
    private List<GatewayDevice> devices;

    public GatewayL2Gateway() {
    }

    public GatewayL2Gateway(String id, String name, String tenantId, List<GatewayDevice> devices) {
        this.id = id;
        this.name = name;
        this.tenantId = tenantId;
        this.devices = devices;
    }

    public static L2GatewayBuilder builder() {
        return new L2GatewayConcreteBuilder();
    }

    public L2GatewayBuilder toBuilder() {
        return new L2GatewayConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public List<? extends Device> getDevices() {
        return this.devices;
    }

    public static class L2Gateways
    extends ListResult<GatewayL2Gateway> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="l2_gateways")
        private List<GatewayL2Gateway> l2Gateways;

        public List<GatewayL2Gateway> value() {
            return this.l2Gateways;
        }
    }

    public static class L2GatewayConcreteBuilder
    implements L2GatewayBuilder {
        private GatewayL2Gateway model;

        public L2GatewayConcreteBuilder() {
            this(new GatewayL2Gateway());
        }

        public L2GatewayConcreteBuilder(GatewayL2Gateway model) {
            this.model = model;
        }

        public L2Gateway build() {
            return this.model;
        }

        public L2GatewayBuilder from(L2Gateway in) {
            if (in != null) {
                this.model = (GatewayL2Gateway)in;
            }
            return this;
        }

        @Override
        public L2GatewayBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public L2GatewayBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public L2GatewayBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public L2GatewayBuilder devices(List<GatewayDevice> devices) {
            this.model.devices = devices;
            return this;
        }
    }
}

