/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstack4j.api.Apis;
import org.openstack4j.api.EndpointTokenProvider;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.artifact.ArtifactService;
import org.openstack4j.api.barbican.BarbicanService;
import org.openstack4j.api.client.CloudProvider;
import org.openstack4j.api.compute.ComputeService;
import org.openstack4j.api.container.AppContainerQuotaService;
import org.openstack4j.api.container.AppContainerService;
import org.openstack4j.api.dns.v2.DNSService;
import org.openstack4j.api.gateway.L2GatewayConnectionService;
import org.openstack4j.api.gateway.L2GatewayService;
import org.openstack4j.api.gbp.GbpService;
import org.openstack4j.api.heat.HeatService;
import org.openstack4j.api.identity.EndpointURLResolver;
import org.openstack4j.api.identity.v2.IdentityService;
import org.openstack4j.api.image.v2.ImageService;
import org.openstack4j.api.magnum.MagnumService;
import org.openstack4j.api.manila.ShareService;
import org.openstack4j.api.murano.v1.AppCatalogService;
import org.openstack4j.api.network.VpnService;
import org.openstack4j.api.networking.NetworkingService;
import org.openstack4j.api.networking.ext.ServiceFunctionChainService;
import org.openstack4j.api.octavia.OctaviaService;
import org.openstack4j.api.placement.PlacementService;
import org.openstack4j.api.sahara.SaharaService;
import org.openstack4j.api.senlin.SenlinService;
import org.openstack4j.api.storage.BlockStorageService;
import org.openstack4j.api.storage.ObjectStorageService;
import org.openstack4j.api.tacker.TackerService;
import org.openstack4j.api.telemetry.TelemetryAodhService;
import org.openstack4j.api.telemetry.TelemetryService;
import org.openstack4j.api.trove.TroveService;
import org.openstack4j.api.types.Facing;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.api.workflow.WorkflowService;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.model.identity.URLResolverParams;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.identity.internal.DefaultEndpointURLResolver;
import org.openstack4j.openstack.identity.v2.functions.ServiceToServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OSClientSession<R, T extends OSClient<T>>
implements EndpointTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OSClientSession.class);
    private static final ThreadLocal<OSClientSession> sessions = new ThreadLocal();
    Config config;
    Facing perspective;
    String region;
    Set<ServiceType> supports;
    CloudProvider provider;
    EndpointURLResolver fallbackEndpointUrlResolver = new DefaultEndpointURLResolver();
    private Map<String, String> headers;

    public static OSClientSession getCurrent() {
        return sessions.get();
    }

    public R useConfig(Config config) {
        this.config = config;
        return (R)this;
    }

    public T useRegion(String region) {
        this.region = region;
        return (T)((OSClient)((Object)this));
    }

    public T removeRegion() {
        return this.useRegion(null);
    }

    public Facing getPerspective() {
        return this.perspective;
    }

    public Config getConfig() {
        return this.config;
    }

    public ComputeService compute() {
        return Apis.getComputeServices();
    }

    public NetworkingService networking() {
        return Apis.getNetworkingServices();
    }

    public PlacementService placement() {
        return Apis.getPlacementServices();
    }

    public ServiceFunctionChainService sfc() {
        return Apis.getSfcServices();
    }

    public OctaviaService octavia() {
        return Apis.getOctaviaService();
    }

    public ArtifactService artifact() {
        return Apis.getArtifactServices();
    }

    public TackerService tacker() {
        return Apis.getTackerServices();
    }

    public org.openstack4j.api.image.ImageService images() {
        return Apis.getImageService();
    }

    public ImageService imagesV2() {
        return Apis.getImageV2Service();
    }

    public BlockStorageService blockStorage() {
        return Apis.get(BlockStorageService.class);
    }

    public TelemetryService telemetry() {
        return Apis.get(TelemetryService.class);
    }

    public ShareService share() {
        return Apis.get(ShareService.class);
    }

    public HeatService heat() {
        return Apis.getHeatServices();
    }

    public AppCatalogService murano() {
        return Apis.getMuranoServices();
    }

    public MagnumService magnum() {
        return Apis.getMagnumService();
    }

    public SenlinService senlin() {
        return Apis.getSenlinServices();
    }

    public ObjectStorageService objectStorage() {
        return Apis.get(ObjectStorageService.class);
    }

    public SaharaService sahara() {
        return Apis.getSaharaServices();
    }

    public WorkflowService workflow() {
        return Apis.getWorkflowServices();
    }

    public BarbicanService barbican() {
        return Apis.getBarbicanServices();
    }

    public DNSService dns() {
        return Apis.getDNSService();
    }

    public T perspective(Facing perspective) {
        this.perspective = perspective;
        return (T)((OSClient)((Object)this));
    }

    public CloudProvider getProvider() {
        return this.provider == null ? CloudProvider.UNKNOWN : this.provider;
    }

    public T headers(Map<String, String> headers) {
        this.headers = headers;
        return (T)((OSClient)((Object)this));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean supportsCompute() {
        return this.getSupportedServices().contains((Object)ServiceType.COMPUTE);
    }

    public boolean supportsIdentity() {
        return this.getSupportedServices().contains((Object)ServiceType.IDENTITY);
    }

    public boolean supportsNetwork() {
        return this.getSupportedServices().contains((Object)ServiceType.NETWORK);
    }

    public boolean supportsPlacement() {
        return this.getSupportedServices().contains((Object)ServiceType.PLACEMENT);
    }

    public boolean supportsImage() {
        return this.getSupportedServices().contains((Object)ServiceType.IMAGE);
    }

    public boolean supportsHeat() {
        return this.getSupportedServices().contains((Object)ServiceType.ORCHESTRATION);
    }

    public boolean supportsMurano() {
        return this.getSupportedServices().contains((Object)ServiceType.APP_CATALOG);
    }

    public boolean supportsBlockStorage() {
        return this.getSupportedServices().contains((Object)ServiceType.BLOCK_STORAGE);
    }

    public boolean supportsObjectStorage() {
        return this.getSupportedServices().contains((Object)ServiceType.OBJECT_STORAGE);
    }

    public boolean supportsTelemetry() {
        return this.getSupportedServices().contains((Object)ServiceType.TELEMETRY);
    }

    public boolean supportsTelemetry_aodh() {
        return this.getSupportedServices().contains((Object)ServiceType.TELEMETRY_AODH);
    }

    public boolean supportsShare() {
        return this.getSupportedServices().contains((Object)ServiceType.SHARE);
    }

    public boolean supportsTrove() {
        return this.getSupportedServices().contains((Object)ServiceType.DATABASE);
    }

    public boolean supportsDNS() {
        return this.getSupportedServices().contains((Object)ServiceType.DNS);
    }

    public Set<ServiceType> getSupportedServices() {
        return null;
    }

    public AuthVersion getAuthVersion() {
        return null;
    }

    public GbpService gbp() {
        return Apis.getGbpServices();
    }

    public TroveService trove() {
        return Apis.getTroveServices();
    }

    public static class OSClientSessionV2
    extends OSClientSession<OSClientSessionV2, OSClient.OSClientV2>
    implements OSClient.OSClientV2 {
        Access access;

        private OSClientSessionV2(Access access, String endpoint, Facing perspective, CloudProvider provider, Config config) {
            this.access = access;
            this.config = config;
            this.perspective = perspective;
            this.provider = provider;
            sessions.set(this);
        }

        private OSClientSessionV2(Access access, OSClientSessionV2 parent, String region) {
            this.access = parent.access;
            this.perspective = parent.perspective;
            this.region = region;
        }

        public static OSClientSessionV2 createSession(Access access) {
            return new OSClientSessionV2(access, access.getEndpoint(), null, null, null);
        }

        public static OSClientSessionV2 createSession(Access access, Facing perspective, CloudProvider provider, Config config) {
            return new OSClientSessionV2(access, access.getEndpoint(), perspective, provider, config);
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getEndpoint() {
            return this.access.getEndpoint();
        }

        @Override
        public AppContainerService appcontainer() {
            return Apis.getAppContainerService();
        }

        @Override
        public AppContainerQuotaService appcontainerQuota() {
            return Apis.getAppContainerQuotaService();
        }

        @Override
        public L2GatewayService l2gateway() {
            return Apis.getL2GatewayService();
        }

        @Override
        public L2GatewayConnectionService l2gatewayConnection() {
            return Apis.getL2GatewayConnectionService();
        }

        @Override
        public VpnService vpn() {
            return Apis.getVpnService();
        }

        @Override
        public AuthVersion getAuthVersion() {
            return AuthVersion.V2;
        }

        private String addNATIfApplicable(String url) {
            if (this.config != null && this.config.isBehindNAT()) {
                try {
                    URI uri = new URI(url);
                    return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
                }
                catch (URISyntaxException var3) {
                    LOG.error(var3.getMessage(), (Throwable)var3);
                }
            }
            return url;
        }

        public String getEndpoint(ServiceType service) {
            EndpointURLResolver eUrlResolver = this.config != null && this.config.getEndpointURLResolver() != null ? this.config.getEndpointURLResolver() : this.fallbackEndpointUrlResolver;
            return this.addNATIfApplicable(eUrlResolver.findURLV2(URLResolverParams.create((Access)this.access, (ServiceType)service).resolver(this.config != null ? this.config.getV2Resolver() : null).perspective(this.perspective).region(this.region)));
        }

        public String getTokenId() {
            return this.access.getToken().getId();
        }

        @Override
        public IdentityService identity() {
            return Apis.getIdentityV2Services();
        }

        @Override
        public Set<ServiceType> getSupportedServices() {
            if (this.supports == null) {
                List types = this.access.getServiceCatalog().stream().map(new ServiceToServiceType()).collect(Collectors.toList());
                this.supports = Collections.unmodifiableSet(EnumSet.copyOf(types));
            }
            return this.supports;
        }
    }

    public static class OSClientSessionV3
    extends OSClientSession<OSClientSessionV3, OSClient.OSClientV3>
    implements OSClient.OSClientV3 {
        protected String reqId;
        Token token;

        private OSClientSessionV3(Token token, String endpoint, Facing perspective, CloudProvider provider, Config config) {
            this.token = token;
            this.config = config;
            this.perspective = perspective;
            this.provider = provider;
            sessions.set(this);
        }

        private OSClientSessionV3(Token token, OSClientSessionV3 parent, String region) {
            this.token = parent.token;
            this.perspective = parent.perspective;
            this.region = region;
        }

        public static OSClientSessionV3 createSession(Token token) {
            return new OSClientSessionV3(token, token.getEndpoint(), null, null, null);
        }

        public static OSClientSessionV3 createSession(Token token, Facing perspective, CloudProvider provider, Config config) {
            return new OSClientSessionV3(token, token.getEndpoint(), perspective, provider, config);
        }

        public String getXOpenstackRequestId() {
            return this.reqId;
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public String getEndpoint() {
            return this.token.getEndpoint();
        }

        @Override
        public AuthVersion getAuthVersion() {
            return AuthVersion.V3;
        }

        private String addNATIfApplicable(String url) {
            if (this.config != null && this.config.isBehindNAT()) {
                try {
                    URI uri = new URI(url);
                    return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
                }
                catch (URISyntaxException var3) {
                    LoggerFactory.getLogger(OSClientSessionV3.class).error(var3.getMessage(), (Throwable)var3);
                }
            }
            return url;
        }

        public String getEndpoint(ServiceType service) {
            EndpointURLResolver eUrlResolver = this.config != null && this.config.getEndpointURLResolver() != null ? this.config.getEndpointURLResolver() : this.fallbackEndpointUrlResolver;
            return this.addNATIfApplicable(eUrlResolver.findURLV3(URLResolverParams.create((Token)this.token, (ServiceType)service).resolver(this.config != null ? this.config.getResolver() : null).perspective(this.perspective).region(this.region)));
        }

        public String getTokenId() {
            return this.token.getId();
        }

        @Override
        public org.openstack4j.api.identity.v3.IdentityService identity() {
            return Apis.getIdentityV3Services();
        }

        @Override
        public Set<ServiceType> getSupportedServices() {
            if (this.supports == null) {
                List types = this.token.getCatalog().stream().map(new org.openstack4j.openstack.identity.v3.functions.ServiceToServiceType()).collect(Collectors.toList());
                this.supports = Collections.unmodifiableSet(EnumSet.copyOf(types));
            }
            return this.supports;
        }

        @Override
        public TelemetryService telemetry() {
            return (TelemetryService)Apis.get(TelemetryAodhService.class);
        }

        @Override
        public AppContainerService appcontainer() {
            return Apis.getAppContainerService();
        }

        @Override
        public AppContainerQuotaService appcontainerQuota() {
            return Apis.getAppContainerQuotaService();
        }

        @Override
        public L2GatewayService l2gateway() {
            return Apis.getL2GatewayService();
        }

        @Override
        public L2GatewayConnectionService l2gatewayConnection() {
            return Apis.getL2GatewayConnectionService();
        }

        @Override
        public VpnService vpn() {
            return Apis.getVpnService();
        }
    }
}

