/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc;

import com.xphsc.easyjdbc.EasyJdbcOperations;
import com.xphsc.easyjdbc.EasyJdbcSelector;
import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.entity.Example;
import com.xphsc.easyjdbc.core.entity.InsertMode;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.BooleanSupplier;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.lambda.Reflections;
import com.xphsc.easyjdbc.core.lambda.StringSupplier;
import com.xphsc.easyjdbc.core.support.EasyJdbcAccessor;
import com.xphsc.easyjdbc.executor.BatchInsertExecutor;
import com.xphsc.easyjdbc.executor.BatchUpdateExecutor;
import com.xphsc.easyjdbc.executor.CountExecutor;
import com.xphsc.easyjdbc.executor.DeleteExecutor;
import com.xphsc.easyjdbc.executor.ExecProcExecutor;
import com.xphsc.easyjdbc.executor.FindExecutor;
import com.xphsc.easyjdbc.executor.GetExecutor;
import com.xphsc.easyjdbc.executor.InsertExecutor;
import com.xphsc.easyjdbc.executor.UpdateExecutor;
import com.xphsc.easyjdbc.executor.ids.DeleteByIdsExecutor;
import com.xphsc.easyjdbc.executor.ids.FindByIdsExecutor;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.page.PageInfoImpl;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Collects;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class EasyJdbcTemplate
extends EasyJdbcAccessor
implements EasyJdbcOperations {
    public EasyJdbcTemplate() {
        this.setJdbcTemplate(JdbcTemplate::new);
    }

    @Override
    public int insert(Object persistent) throws JdbcDataException {
        Assert.notNull(persistent, "Entities cannot be empty");
        InsertExecutor executor = new InsertExecutor(this::getJdbcBuilder, persistent, InsertMode.IGNORENULL);
        int rows = (Integer)executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public int insertWithNull(Object persistent) throws JdbcDataException {
        Assert.notNull(persistent, "Entities cannot be empty");
        InsertExecutor executor = new InsertExecutor(this::getJdbcBuilder, persistent);
        int rows = (Integer)executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public Object insertKey(Object persistent) throws JdbcDataException {
        Assert.notNull(persistent, "Entities cannot be empty");
        InsertExecutor executor = new InsertExecutor(this::getJdbcBuilder, persistent, true, InsertMode.IGNORENULL);
        Object rows = executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public int batchInsert(List<?> persistents) throws JdbcDataException {
        Assert.notEmpty(persistents, "Entity list cannot be empty");
        BatchInsertExecutor executor = new BatchInsertExecutor(this::getJdbcBuilder, persistents);
        int[] rows = (int[])executor.execute();
        executor = null;
        return rows.length;
    }

    @Override
    public int insert(SQL insertSql, Object ... parameters) throws JdbcDataException {
        Assert.hasText(insertSql.toString(), "The SQL constructor cannot be empty");
        int rows = this.getJdbcBuilder().update(insertSql.toString(), parameters);
        return rows;
    }

    @Override
    public int deleteByPrimaryKey(Class<?> persistentClass, Serializable primaryKeyValue) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.notNull(primaryKeyValue, "Primary key cannot be empty");
        Assert.hasText(primaryKeyValue.toString(), "Primary key cannot be empty");
        DeleteExecutor executor = new DeleteExecutor(this::getJdbcBuilder, persistentClass, primaryKeyValue);
        int rows = (Integer)executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public int deleteByIds(Class<?> persistentClass, Iterable primaryKeyValues) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.notNull(primaryKeyValues, "Primary key cannot be empty");
        Assert.hasText(primaryKeyValues.toString(), "Primary key cannot be empty");
        DeleteByIdsExecutor executor = new DeleteByIdsExecutor(this::getJdbcBuilder, persistentClass, primaryKeyValues);
        int rows = (Integer)executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public int delete(SQL deleteSql, Object ... parameters) throws JdbcDataException {
        Assert.hasText(deleteSql.toString(), "The SQL constructor cannot be empty");
        int rows = this.getJdbcBuilder().update(deleteSql.toString(), parameters);
        return rows;
    }

    @Override
    public int update(Object persistent) throws JdbcDataException {
        Assert.notNull(persistent, "Entities cannot be empty");
        UpdateExecutor executor = new UpdateExecutor(this::getJdbcBuilder, persistent, true);
        int rows = (Integer)executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public int batchUpdate(List<?> persistents) throws JdbcDataException {
        Assert.notEmpty(persistents, "Entity list cannot be emp");
        BatchUpdateExecutor executor = new BatchUpdateExecutor(this::getJdbcBuilder, persistents);
        int[] rows = (int[])executor.execute();
        executor = null;
        return rows.length;
    }

    @Override
    public int update(SQL updateSql, Object ... parameters) throws JdbcDataException {
        Assert.notNull(updateSql, "The SQL constructor cannot be empty");
        int rows = this.getJdbcBuilder().update(updateSql.toString(), parameters);
        return rows;
    }

    @Override
    public <T> T getByPrimaryKey(Class<?> persistentClass, Serializable primaryKeyValue) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.notNull(primaryKeyValue, "Primary key cannot be empty");
        GetExecutor executor = new GetExecutor(this::getJdbcBuilder, persistentClass, primaryKeyValue);
        try {
            Object entity = executor.execute();
            return entity;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            executor = null;
            return null;
        }
    }

    @Override
    public <T> T get(String sql, Class<?> persistentClass, Object ... parameters) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        List<T> results = this.find(sql, persistentClass, parameters);
        return Collects.isNotEmpty(results) ? (T)results.get(0) : null;
    }

    @Override
    public <T> List<T> findAll(Class<?> persistentClass) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Example example = this.example(persistentClass);
        return example.list();
    }

    @Override
    public <T> List<T> findAll(Class<?> persistentClass, PageInfo page) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Example example = this.example(persistentClass);
        if (page.getOffset() == -1) {
            Assert.isTrue(page.getPageNum() >= 1, " PageNum must be greater than or equal to 1");
            Assert.isTrue(page.getPageSize() > 0, "PageSize must be greater than 0");
            example.pageInfo(page.getPageNum(), page.getPageSize());
        } else {
            Assert.isTrue(page.getOffset() >= 0, " 0ffset must be greater than or equal to 0");
            Assert.isTrue(page.getLimit() > 0, "Limit must be greater than 0");
            example.offsetPage(page.getOffset(), page.getLimit());
        }
        return example.list();
    }

    @Override
    public <T> List<T> find(SQL selectSql, Class<?> persistentClass, Object ... parameters) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.hasText(selectSql.toString(), "SQL statement cannot be empty");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.getDialectName(), persistentClass, selectSql.toString(), parameters);
        List list = (List)executor.execute();
        executor = null;
        return list;
    }

    @Override
    public <T> List<T> find(SQL selectSql, Class<?> persistentClass, Integer offset, Integer limit, Object ... parameters) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.hasText(selectSql.toString(), "SQL statement cannot be empty");
        Assert.isTrue(offset >= 0, "0ffset must be greater than or equal to 0");
        Assert.isTrue(limit > 0, "Limit must be greater than 0");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.getDialectName(), persistentClass, selectSql.toString(), parameters, null, offset, limit);
        List list = (List)executor.execute();
        executor = null;
        return list;
    }

    @Override
    public <T> List<T> find(SQL selectSql, Class<?> persistentClass, PageInfo page, Object ... parameters) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.hasText(selectSql.toString(), "SQL statement cannot be empty");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.getDialectName(), persistentClass, selectSql.toString(), parameters, null, page);
        List list = (List)executor.execute();
        executor = null;
        return list;
    }

    @Override
    public <T> PageInfo<T> findByPage(SQL selectSql, Class<?> persistentClass, PageInfo page, Object ... parameters) throws JdbcDataException {
        List<T> list = this.find(selectSql, persistentClass, page, parameters);
        long total = this.count(selectSql.toString(), parameters);
        PageInfo pageInfo = this.pageInfo(page);
        return new PageInfoImpl<T>(list, total, pageInfo.getPageNum(), pageInfo.getPageSize());
    }

    @Override
    public <T> List<T> find(String sql, Class<?> persistentClass, Object ... parameters) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.hasText(sql, "SQL statement cannot be empty");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.getDialectName(), persistentClass, sql, parameters);
        List list = (List)executor.execute();
        executor = null;
        return list;
    }

    @Override
    public List<Map<String, Object>> find(String sql, Object ... parameters) throws JdbcDataException {
        Assert.hasText(sql, "SQL statement cannot be empty");
        List<Map<String, Object>> list = this.getJdbcBuilder().queryForList(sql, parameters);
        return list;
    }

    @Override
    public <T> List<T> find(String sql, Class<?> persistentClass, PageInfo page, Object ... parameters) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.hasText(sql, "SQL statement cannot be empty");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.getDialectName(), persistentClass, sql, parameters, null, page);
        List list = (List)executor.execute();
        executor = null;
        return list;
    }

    @Override
    public <T> PageInfo<T> findByPage(String selectSql, Class<?> persistentClass, PageInfo page, Object ... parameters) throws JdbcDataException {
        List<T> list = this.find(selectSql, persistentClass, page, parameters);
        long total = this.count(selectSql, parameters);
        PageInfo pageInfo = this.pageInfo(page);
        return new PageInfoImpl<T>(list, total, pageInfo.getPageNum(), pageInfo.getPageSize());
    }

    @Override
    public <T> List<T> find(String sql, Class<?> persistentClass, Integer offset, Integer limit, Object ... parameters) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.hasText(sql, "SQL statement cannot be empty");
        Assert.isTrue(offset >= 0, "Offset must be greater than or equal to 0");
        Assert.isTrue(limit > 0, "Limit must be greater than 0");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.getDialectName(), persistentClass, sql, parameters, null, offset, limit);
        List list = (List)executor.execute();
        executor = null;
        return list;
    }

    @Override
    public <T> PageInfo<T> findByPage(String selectSql, Class<?> persistentClass, Integer offset, Integer limit, Object ... parameters) throws JdbcDataException {
        List<T> list = this.find(selectSql, persistentClass, offset, limit, parameters);
        long total = this.count(selectSql.toString(), parameters);
        PageInfo page = PageInfo.builder().offset(offset).limit(limit).build();
        PageInfo pageInfo = this.pageInfo(page);
        return new PageInfoImpl<T>(list, total, pageInfo.getPageNum(), pageInfo.getPageSize());
    }

    @Override
    public <T> List<T> findByIds(Class<?> persistentClass, Iterable values) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        Assert.notNull(values, "Ids cannot be empty");
        FindByIdsExecutor executor = new FindByIdsExecutor(this::getJdbcBuilder, persistentClass, values);
        List list = (List)executor.execute();
        executor = null;
        return list;
    }

    @Override
    public long count(String sql, Object ... parameters) throws JdbcDataException {
        Assert.hasText(sql, "SQL statement cannot be empty");
        CountExecutor executor = new CountExecutor(this::getJdbcBuilder, sql, parameters);
        long count = (Long)executor.execute();
        executor = null;
        return count;
    }

    @Override
    public long count(Class<?> persistentClass) throws JdbcDataException {
        Assert.notNull(persistentClass, "Entity type cannot be empty");
        CountExecutor executor = new CountExecutor(this::getJdbcBuilder, persistentClass);
        long count = (Long)executor.execute();
        executor = null;
        return count;
    }

    @Override
    public Map<?, ?> call(String sql, Class<?> persistentClass, Map<Integer, Integer> outParameters, Object[] parameters) throws JdbcDataException {
        ExecProcExecutor executor = new ExecProcExecutor(this::getJdbcBuilder, sql, persistentClass, outParameters, parameters);
        Map map = (Map)executor.execute();
        executor = null;
        return map;
    }

    @Deprecated
    public <T> List<T> findByExample(Example example) throws JdbcDataException {
        example.jdbcBuilder = this.getJdbcBuilder();
        example.dialectName = this.getDialectName();
        List list = example.list();
        return list;
    }

    @Deprecated
    public <T> T getByExample(Example example) throws JdbcDataException {
        example.jdbcBuilder = this.getJdbcBuilder();
        example.dialectName = this.getDialectName();
        return example.get();
    }

    @Deprecated
    public long countByExample(Example example) throws JdbcDataException {
        example.jdbcBuilder = this.getJdbcBuilder();
        example.dialectName = this.getDialectName();
        long count = example.count();
        return count;
    }

    @Deprecated
    public <T> PageInfo<T> findByPage(Example example) throws JdbcDataException {
        example.jdbcBuilder = this.getJdbcBuilder();
        example.dialectName = this.getDialectName();
        PageInfo pageInfo = example.page();
        return pageInfo;
    }

    @Override
    public void execute(String sql) {
        this.getJdbcBuilder().execute(sql);
    }

    @Override
    public EasyJdbcSelector selector() {
        return new EasyJdbcSelector(this::getJdbcBuilder, this::getDialectName);
    }

    @Override
    public Example example(Class<?> persistentClass) {
        Example example = new Example(persistentClass);
        example.jdbcBuilder = this.getJdbcBuilder();
        example.dialectName = this.getDialectName();
        return example;
    }

    @Override
    public void clear() {
        this.getJdbcBuilder().clear();
    }

    private EasyJdbcTemplate(Builder builder) {
        if (builder.jdbcTemplate != null) {
            this.setJdbcTemplate(builder.jdbcTemplate);
        } else {
            this.setJdbcTemplate(JdbcTemplate::new);
        }
        this.setDataSource(builder.dataSource);
        this.setDialectName(builder.dialectName);
        this.useLocalCache(builder.useLocalCache);
        this.showSQL(builder.showSQL);
        this.afterPropertiesSet();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JdbcTemplate jdbcTemplate;
        private DataSource dataSource;
        private String dialectName;
        private boolean useLocalCache;
        private boolean showSQL;

        public Builder jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return this;
        }

        public <S> Builder jdbcTemplate(LambdaSupplier<S> jdbcTemplate) {
            this.jdbcTemplate = (JdbcTemplate)Reflections.classForLambdaSupplier(jdbcTemplate);
            return this;
        }

        public Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public <S> Builder dataSource(LambdaSupplier<S> dataSource) {
            this.dataSource = (DataSource)Reflections.classForLambdaSupplier(dataSource);
            return this;
        }

        public Builder dialectName(String dialectName) {
            this.dialectName = dialectName;
            return this;
        }

        public Builder dialectName(StringSupplier dialectName) {
            this.dialectName = (String)dialectName.get();
            return this;
        }

        public Builder useLocalCache(boolean useLocalCache) {
            this.useLocalCache = useLocalCache;
            return this;
        }

        public Builder useLocalCache(BooleanSupplier useLocalCache) {
            this.useLocalCache = useLocalCache.getAsBoolean();
            return this;
        }

        public Builder showSQL(boolean showSQL) {
            this.showSQL = showSQL;
            return this;
        }

        public Builder showSQL(BooleanSupplier showSQL) {
            this.showSQL = showSQL.getAsBoolean();
            return this;
        }

        public EasyJdbcTemplate build() {
            return new EasyJdbcTemplate(this);
        }
    }
}

