/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core;

import com.xphsc.easyjdbc.EasyJdbcSelector;
import com.xphsc.easyjdbc.EasyJdbcTemplate;
import com.xphsc.easyjdbc.core.EasyJdbcDao;
import com.xphsc.easyjdbc.core.entity.Example;
import com.xphsc.easyjdbc.core.entity.Sorts;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.support.JdbcBuilder;
import com.xphsc.easyjdbc.executor.DeleteExecutor;
import com.xphsc.easyjdbc.executor.UpdateExecutor;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.util.Assert;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;

public class SimpleJdbcDao<T>
implements EasyJdbcDao<T> {
    public Class<T> modelClass;
    private JdbcBuilder jdbcBuilder;
    private String dialectName;
    private EasyJdbcTemplate easyJdbcTemplate;

    public SimpleJdbcDao(EasyJdbcTemplate easyJdbcTemplate) {
        this.easyJdbcTemplate = easyJdbcTemplate;
    }

    public SimpleJdbcDao() {
        if (this.getClass().getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.modelClass = (Class)pt.getActualTypeArguments()[0];
        }
    }

    public void easyJdbcTemplate(LambdaSupplier<EasyJdbcTemplate> easyJdbcTemplate) {
        this.easyJdbcTemplate = this.getEasyJdbcTemplate() != null ? this.getEasyJdbcTemplate() : (EasyJdbcTemplate)easyJdbcTemplate.get();
        this.jdbcBuilder = this.easyJdbcTemplate.getJdbcBuilder();
        this.dialectName = this.easyJdbcTemplate.getDialectName();
    }

    @Override
    public EasyJdbcTemplate getEasyJdbcTemplate() {
        return this.easyJdbcTemplate;
    }

    @Override
    public int insert(T persistent) throws JdbcDataException {
        Assert.notNull(persistent, "Entity cannot be empty");
        int rows = this.easyJdbcTemplate.insert(persistent);
        return rows;
    }

    @Override
    public Object insertForKey(T persistent) {
        return this.easyJdbcTemplate.insertKey(persistent);
    }

    @Override
    public int batchInsert(List<T> persistents) throws JdbcDataException {
        Assert.notEmpty(persistents, "Entity list cannot be empty");
        int rows = this.easyJdbcTemplate.batchInsert(persistents);
        return rows;
    }

    @Override
    public int deleteByPrimaryKey(Serializable primaryKeyValue) {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        Assert.notNull(primaryKeyValue, "Primary key cannot be empty");
        int rows = this.easyJdbcTemplate.deleteByPrimaryKey(this.modelClass, primaryKeyValue);
        return rows;
    }

    @Override
    public int deleteByIds(Iterable primaryKeyValues) {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        int rows = this.easyJdbcTemplate.deleteByIds(this.modelClass, primaryKeyValues);
        return rows;
    }

    @Override
    public int delete(T persistent) {
        DeleteExecutor executor = new DeleteExecutor(this::getJdbcBuilder, persistent);
        int rows = (Integer)executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public int update(T persistent) throws JdbcDataException {
        Assert.notNull(persistent, "Entities cannot be empty");
        int rows = this.easyJdbcTemplate.update(persistent);
        return rows;
    }

    @Override
    public int updateWithNull(T persistent) {
        UpdateExecutor executor = new UpdateExecutor(this::getJdbcBuilder, persistent, false);
        int rows = (Integer)executor.execute();
        executor = null;
        return rows;
    }

    @Override
    public int batchUpdate(List<T> persistents) throws JdbcDataException {
        Assert.notEmpty(persistents, "Entity list cannot be empty");
        int rows = this.easyJdbcTemplate.batchUpdate(persistents);
        return rows;
    }

    @Override
    public boolean exists(Serializable primaryKeyValue) {
        return this.getByPrimaryKey(primaryKeyValue) != null;
    }

    @Override
    public <T> T getByPrimaryKey(Serializable primaryKeyValue) {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        Assert.notNull(primaryKeyValue, "Primary key cannot be empty");
        Object entity = this.easyJdbcTemplate.getByPrimaryKey(this.modelClass, primaryKeyValue);
        return entity;
    }

    @Override
    public Optional<T> getById(Serializable id) {
        return Optional.ofNullable(this.getByPrimaryKey(id));
    }

    @Override
    public long count() {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        Example example = this.example();
        return example.count();
    }

    @Override
    public <T> List<T> findAll() {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        Example example = this.example();
        return example.list();
    }

    @Override
    public <T> List<T> findAll(Sorts sort) {
        Example example = this.example();
        example.orderByClause(sort);
        return example.list();
    }

    @Override
    public <T> PageInfo<T> findAll(PageInfo pageInfo) {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        Example example = this.example();
        if (pageInfo.getOffset() == -1 && pageInfo.getPageNum() >= 1) {
            example.pageInfo(pageInfo.getPageNum(), pageInfo.getPageSize());
        } else {
            example.offsetPage(pageInfo.getOffset() >= 0 ? pageInfo.getOffset() : 0, pageInfo.getLimit());
        }
        return example.page();
    }

    @Override
    public <T> PageInfo<T> findAll(PageInfo pageInfo, Sorts sort) {
        Example example = this.example();
        example.orderByClause(sort);
        if (pageInfo.getOffset() == -1 && pageInfo.getPageNum() >= 1) {
            example.pageInfo(pageInfo.getPageNum(), pageInfo.getPageSize());
        } else {
            example.offsetPage(pageInfo.getOffset() >= 0 ? pageInfo.getOffset() : 0, pageInfo.getLimit());
        }
        return example.page();
    }

    @Override
    public <T> List<T> findByIds(Iterable values) {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        List list = this.easyJdbcTemplate.findByIds(this.modelClass, values);
        return list;
    }

    @Override
    public EasyJdbcSelector selector() {
        return this.easyJdbcTemplate.selector();
    }

    @Override
    public Example example() {
        Assert.notNull(this.modelClass, "Entity interface generic type cannot be empty");
        return this.easyJdbcTemplate.example(this.modelClass);
    }

    @Override
    public void cacheClear() {
        this.easyJdbcTemplate.clear();
    }

    private JdbcBuilder getJdbcBuilder() {
        return this.jdbcBuilder;
    }

    private String getDialectName() {
        return this.dialectName;
    }
}

