/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.parser;

import com.xphsc.easyjdbc.annotation.SqlDelete;
import com.xphsc.easyjdbc.annotation.SqlDeleteProvider;
import com.xphsc.easyjdbc.annotation.SqlInsert;
import com.xphsc.easyjdbc.annotation.SqlInsertProvider;
import com.xphsc.easyjdbc.annotation.SqlSelect;
import com.xphsc.easyjdbc.annotation.SqlSelectProvider;
import com.xphsc.easyjdbc.annotation.SqlUpdate;
import com.xphsc.easyjdbc.annotation.SqlUpdateProvider;
import com.xphsc.easyjdbc.core.metadata.SQLOptionType;
import com.xphsc.easyjdbc.core.parser.SQLOptionTypeParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class DefaultSQLOptionTypeParser
implements SQLOptionTypeParser {
    private static Set<Class<? extends Annotation>> sqlAnnotationTypes = new HashSet<Class<? extends Annotation>>();
    private static Set<Class<? extends Annotation>> sqlProviderAnnotationTypes = new HashSet<Class<? extends Annotation>>();

    @Override
    public SQLOptionType getSqlCommandType(Method method) {
        Class<? extends Annotation> type = this.getSqlAnnotationType(method);
        if (type == null) {
            type = this.getSqlProviderAnnotationType(method);
            if (type == null) {
                return SQLOptionType.UNKNOWN;
            }
            if (type == SqlSelectProvider.class) {
                type = SqlSelect.class;
            } else if (type == SqlInsertProvider.class) {
                type = SqlInsert.class;
            } else if (type == SqlUpdateProvider.class) {
                type = SqlUpdate.class;
            } else if (type == SqlDeleteProvider.class) {
                type = SqlDelete.class;
            }
        }
        return SQLOptionType.valueOf(type.getSimpleName().toUpperCase(Locale.ENGLISH));
    }

    private Class<? extends Annotation> getSqlAnnotationType(Method method) {
        return this.chooseAnnotationType(method, sqlAnnotationTypes);
    }

    private Class<? extends Annotation> getSqlProviderAnnotationType(Method method) {
        return this.chooseAnnotationType(method, sqlProviderAnnotationTypes);
    }

    private Class<? extends Annotation> chooseAnnotationType(Method method, Set<Class<? extends Annotation>> types) {
        for (Class<? extends Annotation> type : types) {
            Annotation annotation = method.getAnnotation(type);
            if (annotation == null) continue;
            return type;
        }
        return null;
    }

    static {
        sqlAnnotationTypes.add(SqlSelect.class);
        sqlAnnotationTypes.add(SqlInsert.class);
        sqlAnnotationTypes.add(SqlDelete.class);
        sqlAnnotationTypes.add(SqlUpdate.class);
        sqlProviderAnnotationTypes.add(SqlSelectProvider.class);
        sqlProviderAnnotationTypes.add(SqlUpdateProvider.class);
        sqlProviderAnnotationTypes.add(SqlInsertProvider.class);
        sqlProviderAnnotationTypes.add(SqlDeleteProvider.class);
    }
}

