/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.parser;

import com.xphsc.easyjdbc.core.parser.SQLParser;
import com.xphsc.easyjdbc.util.Beans;
import com.xphsc.easyjdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultSQLParser
implements SQLParser {
    private static final String EMPTY = "";
    private Map<String, Object> objectMap;
    private static String REGEX_HASORDERS = "order\\s*by[\\w|\\W|\\s|\\S]*";
    private static String UPDATE = "UPDATE";
    private static final Pattern FIELD_PLACE_HOLDER_PATTERN = Pattern.compile("\\#\\{\\s*\\w+\\s*\\}");
    private static final Pattern OGNL_PLACE_HOLDER_PATTERN = Pattern.compile(":[ tnx0Bfr]*[0-9a-z.A-Z_]+");
    private static final Pattern OBJECT_PLACE_HOLDER_PATTERN = Pattern.compile("#\\{[ tnx0Bfr]*[0-9a-z.A-Z_]+\\}");

    @Override
    public Boolean hasFieldPlaceHolder(String sqlString) {
        Boolean flag = false;
        Matcher m = FIELD_PLACE_HOLDER_PATTERN.matcher(sqlString);
        while (m.find()) {
            flag = true;
        }
        return flag;
    }

    @Override
    public Boolean hasOgnlPlaceHolder(String sqlString) {
        Boolean flag = false;
        Matcher m = OGNL_PLACE_HOLDER_PATTERN.matcher(sqlString);
        while (m.find()) {
            flag = true;
        }
        return flag;
    }

    @Override
    public Boolean hasObjectPlaceHolder(String sqlString) {
        Boolean flag = false;
        Matcher m = OBJECT_PLACE_HOLDER_PATTERN.matcher(sqlString);
        while (m.find()) {
            flag = true;
        }
        return flag;
    }

    @Override
    public Object[] sqlPlaceHolder(String sql, Map<String, Object> params, boolean isOgnl) {
        ArrayList<Object> list;
        block8: {
            Map<String, Object> entityMap;
            Matcher m = null;
            ArrayList<String> matchRegexList = new ArrayList<String>(10);
            list = new ArrayList<Object>();
            String newkey = null;
            m = isOgnl ? OGNL_PLACE_HOLDER_PATTERN.matcher(sql) : OBJECT_PLACE_HOLDER_PATTERN.matcher(sql);
            while (m.find()) {
                matchRegexList.add(m.group());
            }
            Object val = null;
            for (String key : matchRegexList) {
                if (isOgnl) {
                    key = key.substring(1, key.length()).replace(" ", EMPTY);
                    sql = sql.replaceFirst("\\:\\s*" + key + "\\s*", "? ");
                    newkey = key;
                    val = params.get(key);
                } else {
                    key = key.substring(2, key.length() - 1).replace(" ", EMPTY);
                    sql = sql.replaceFirst("\\#\\{" + key + "\\s*\\}", "? ");
                    newkey = key;
                    val = params.get(key);
                }
                if (val == null) continue;
                list.add(val);
            }
            if (val != null || params == null) break block8;
            Object value = params.get(StringUtil.substringBeforeLast(newkey, "."));
            if (sql.toUpperCase().trim().contains(UPDATE)) {
                entityMap = Beans.beanToTreeMap(value);
                for (Map.Entry entity : ((TreeMap)entityMap).entrySet()) {
                    if ("class".equals(entity.getKey()) || entity.getValue() == null) continue;
                    list.add(entity.getValue());
                }
            } else {
                entityMap = Beans.beanToMap(value);
                this.objectMap = entityMap;
                for (Map.Entry<String, Object> entity : entityMap.entrySet()) {
                    if ("class".equals(entity.getKey()) || entity.getValue() == null) continue;
                    list.add(entity.getValue());
                }
            }
        }
        return new Object[]{sql, list.toArray()};
    }

    @Override
    public Map<String, Object> entityMap() {
        return this.objectMap;
    }

    @Override
    public String removeOrders(String sql) {
        Pattern p = Pattern.compile(REGEX_HASORDERS, 2);
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, EMPTY);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public Boolean hasOrders(String sql) {
        Boolean flag = false;
        Pattern p = Pattern.compile(REGEX_HASORDERS, 2);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            flag = true;
        }
        return flag;
    }
}

