/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.processor;

import com.xphsc.easyjdbc.core.entity.Sorts;
import com.xphsc.easyjdbc.core.processor.AbstractDaoMethodProcessor;
import com.xphsc.easyjdbc.page.PageInfo;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;

public class BaseMethodProcessor
extends AbstractDaoMethodProcessor {
    private PageInfo pageInfo;

    @Override
    public Object process() {
        this.simpleJdbcDao.modelClass = this.persistentClass;
        MethodName methodName = new MethodName(this.method);
        if (this.parameters != null) {
            MethodParameterType methodParameterType = new MethodParameterType(this.method);
            if (methodParameterType.returnsPage && methodName.returnFindAll) {
                this.pageInfo = (PageInfo)this.parameters[0];
                Sorts sort = null;
                if (this.parameters.length == 2) {
                    sort = (Sorts)this.parameters[1];
                }
                return sort == null ? this.simpleJdbcDao.findAll(this.pageInfo) : this.simpleJdbcDao.findAll(this.pageInfo, sort);
            }
            if (methodParameterType.returnsSorts && methodName.returnFindAll) {
                Sorts sort = (Sorts)this.parameters[0];
                return this.simpleJdbcDao.findAll(sort);
            }
            if (methodParameterType.returnsSerializable) {
                if (methodName.returnGetByPrimaryKey) {
                    return this.simpleJdbcDao.getByPrimaryKey((Serializable)this.parameters[0]);
                }
                if (methodName.returnExists) {
                    return this.simpleJdbcDao.exists((Serializable)this.parameters[0]);
                }
                if (methodName.returnGetById) {
                    return this.simpleJdbcDao.getById((Serializable)this.parameters[0]);
                }
                if (methodName.returnDeleteByPrimaryKey) {
                    return this.simpleJdbcDao.deleteByPrimaryKey((Serializable)this.parameters[0]);
                }
            }
            if (methodParameterType.returnsObject) {
                if (methodName.returnInsert) {
                    return this.simpleJdbcDao.insert(this.parameters[0]);
                }
                if (methodName.returnInsertForKey) {
                    return this.simpleJdbcDao.insertForKey(this.parameters[0]);
                }
                if (methodName.returnUpdate) {
                    return this.simpleJdbcDao.update(this.parameters[0]);
                }
                if (methodName.returnUpdateWithNull) {
                    return this.simpleJdbcDao.updateWithNull(this.parameters[0]);
                }
                if (methodName.returnDelete) {
                    return this.simpleJdbcDao.delete(this.parameters[0]);
                }
            }
            if (methodParameterType.returnsIterable) {
                if (methodName.returnFindByIds) {
                    return this.simpleJdbcDao.findByIds((Iterable)this.parameters[0]);
                }
                if (methodName.returnDeleteByIds) {
                    return this.simpleJdbcDao.deleteByIds((Iterable)this.parameters[0]);
                }
            }
            if (methodParameterType.returnsList) {
                if (methodName.returnBatchInsert) {
                    return this.simpleJdbcDao.batchInsert((List)this.parameters[0]);
                }
                if (methodName.returnBatchUpdate) {
                    return this.simpleJdbcDao.batchUpdate((List)this.parameters[0]);
                }
            }
        } else {
            if (methodName.returnFindAll) {
                return this.simpleJdbcDao.findAll();
            }
            if (methodName.returnCount) {
                return this.simpleJdbcDao.count();
            }
            if (methodName.returnExample) {
                return this.simpleJdbcDao.example();
            }
            if (methodName.returnSelector) {
                return this.simpleJdbcDao.selector();
            }
            if (methodName.returnGetEasyJdbcTemplate) {
                return this.simpleJdbcDao.getEasyJdbcTemplate();
            }
            if (methodName.returnCacheClear) {
                this.simpleJdbcDao.cacheClear();
            }
        }
        return null;
    }

    private class BaseMethodConstants {
        public static final String FIND_ALL = "findAll";
        public static final String GET_BY_PRIMARY_KEY = "getByPrimaryKey";
        public static final String EXISTS = "exists";
        public static final String GET_BY_ID = "getById";
        public static final String DELETE_BY_PRIMARY_KEY = "deleteByPrimaryKey";
        public static final String INSERT = "insert";
        public static final String INSERT_FOR_KEY = "insertForKey";
        public static final String UPDATE = "update";
        public static final String UPDATE_WITH_NULL = "updateWithNull";
        public static final String FIND_BY_IDS = "findByIds";
        public static final String DELETE_BY_IDS = "deleteByIds";
        public static final String DELETE = "delete";
        public static final String BATCH_INSERT = "batchInsert";
        public static final String BATCH_UPDATE = "batchUpdate";
        public static final String COUNT = "count";
        public static final String EXAMPLE = "example";
        public static final String SELECTOR = "selector";
        public static final String CLEAR = "cacheClear";
        public static final String GET_EASY_JDBC_TEMPLATE = "getEasyJdbcTemplate";

        private BaseMethodConstants() {
        }
    }

    public static class MethodName {
        private boolean returnFindAll;
        private boolean returnGetByPrimaryKey;
        private boolean returnExists;
        private boolean returnGetById;
        private boolean returnDeleteByPrimaryKey;
        private boolean returnInsert;
        private boolean returnInsertForKey;
        private boolean returnUpdate;
        private boolean returnUpdateWithNull;
        private boolean returnFindByIds;
        private boolean returnDeleteByIds;
        private boolean returnDelete;
        private boolean returnBatchInsert;
        private boolean returnBatchUpdate;
        private boolean returnCount;
        private boolean returnExample;
        private boolean returnGetEasyJdbcTemplate;
        private boolean returnCacheClear;
        private boolean returnSelector;

        public MethodName(Method method) {
            String name = method.getName();
            if (name.equals("findAll")) {
                this.returnFindAll = true;
            }
            if (name.equals("exists")) {
                this.returnExists = true;
            }
            if (name.equals("getByPrimaryKey")) {
                this.returnGetByPrimaryKey = true;
            }
            if (name.equals("getById")) {
                this.returnGetById = true;
            }
            if (name.equals("deleteByPrimaryKey")) {
                this.returnDeleteByPrimaryKey = true;
            }
            if (name.equals("insert")) {
                this.returnInsert = true;
            }
            if (name.equals("insertForKey")) {
                this.returnInsertForKey = true;
            }
            if (name.equals("update")) {
                this.returnUpdate = true;
            }
            if (name.equals("updateWithNull")) {
                this.returnUpdateWithNull = true;
            }
            if (name.equals("findByIds")) {
                this.returnFindByIds = true;
            }
            if (name.equals("deleteByIds")) {
                this.returnDeleteByIds = true;
            }
            if (name.equals("delete")) {
                this.returnDelete = true;
            }
            if (name.equals("batchInsert")) {
                this.returnBatchInsert = true;
            }
            if (name.equals("batchUpdate")) {
                this.returnBatchUpdate = true;
            }
            if (name.equals("count")) {
                this.returnCount = true;
            }
            if (name.equals("example")) {
                this.returnExample = true;
            }
            if (name.equals("selector")) {
                this.returnSelector = true;
            }
            if (name.equals("getEasyJdbcTemplate")) {
                this.returnGetEasyJdbcTemplate = true;
            }
            if (name.equals("cacheClear")) {
                this.returnCacheClear = true;
            }
        }
    }

    public static class MethodParameterType {
        private boolean returnsSerializable;
        private boolean returnsObject;
        private boolean returnsPage;
        private boolean returnsList;
        private boolean returnsSorts;
        private boolean returnsIterable;

        public MethodParameterType(Method method) {
            Class<Object> parameterType = method.getParameterTypes()[0];
            if (parameterType.isAssignableFrom(Sorts.class)) {
                this.returnsSorts = true;
            }
            if (parameterType.isAssignableFrom(Serializable.class)) {
                this.returnsSerializable = true;
            }
            if (parameterType.isAssignableFrom(PageInfo.class)) {
                this.returnsPage = true;
            }
            if (parameterType.isAssignableFrom(List.class)) {
                this.returnsList = true;
            }
            if (parameterType.isAssignableFrom(Object.class)) {
                this.returnsObject = true;
            }
            if (parameterType.isAssignableFrom(Iterable.class)) {
                this.returnsIterable = true;
            }
        }
    }
}

