/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.support;

import com.xphsc.easyjdbc.core.cache.Cache;
import com.xphsc.easyjdbc.core.cache.CacheKey;
import com.xphsc.easyjdbc.core.cache.PerpetualCache;
import com.xphsc.easyjdbc.core.cache.SimpleCachekeyBuiler;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.BooleanSupplier;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.lambda.Reflections;
import com.xphsc.easyjdbc.core.lambda.StringSupplier;
import com.xphsc.easyjdbc.core.support.DefaultCacheSqlProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcBuilder
extends SimpleCachekeyBuiler {
    private JdbcTemplate jdbcTemplate;
    private static volatile Cache CACHE;
    private boolean useLocalCache;
    private boolean showSQL;
    protected Log logger;

    public <T> JdbcBuilder(LambdaSupplier<T> jdbcTemplate, BooleanSupplier useLocalCache, BooleanSupplier showSQL, StringSupplier interfaceClass) {
        this.jdbcTemplate = (JdbcTemplate)Reflections.classForLambdaSupplier(jdbcTemplate);
        this.useLocalCache = useLocalCache.getAsBoolean();
        this.showSQL = showSQL.getAsBoolean();
        this.logger = LogFactory.getLog((String)((String)interfaceClass.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Cache getCacheInstance() {
        if (CACHE != null) return CACHE;
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            if (CACHE != null) return CACHE;
            CACHE = new PerpetualCache("Localcache");
            // ** MonitorExit[var0] (shouldn't be in output)
            return CACHE;
        }
    }

    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryBuilder(sql, args, rowMapper);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryBuilder(sql, null, rowMapper);
    }

    public List<Map<String, Object>> find(String sql, Object ... parameters) throws JdbcDataException {
        return this.queryBuilder(sql, parameters, null);
    }

    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        return this.selectOne(sql, rowMapper, null, argTypes, args);
    }

    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws DataAccessException {
        return this.selectOne(sql, null, requiredType, null, args);
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.selectOne(sql, null, requiredType, null, args);
    }

    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return this.selectOne(sql, rowMapper, null, null, args);
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.selectOne(sql, rowMapper, null, null, args);
    }

    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return this.queryBuilder(sql, args, null);
    }

    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        return (Map)this.selectOne(sql, null, null, null, args);
    }

    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException {
        this.getShowSQL(sql, null);
        int rows = this.jdbcTemplate.update(sql, pss);
        JdbcBuilder.getCacheInstance().clear();
        return rows;
    }

    public int update(PreparedStatementCreator psc) throws DataAccessException {
        int rows = this.jdbcTemplate.update(psc);
        JdbcBuilder.getCacheInstance().clear();
        return rows;
    }

    public int update(String sql, Object ... args) throws DataAccessException {
        this.getShowSQL(sql, args);
        int rows = this.jdbcTemplate.update(sql, args);
        JdbcBuilder.getCacheInstance().clear();
        return rows;
    }

    public int update(PreparedStatementCreator psc, KeyHolder generatedKeyHolder) throws DataAccessException {
        int rows = this.jdbcTemplate.update(psc, generatedKeyHolder);
        JdbcBuilder.getCacheInstance().clear();
        return rows;
    }

    public int[] batchUpdate(String sql, BatchPreparedStatementSetter pss) throws DataAccessException {
        this.getShowSQL(sql, null);
        int[] rows = this.jdbcTemplate.batchUpdate(sql, pss);
        JdbcBuilder.getCacheInstance().clear();
        return rows;
    }

    public int[] batchUpdate(String sql) throws DataAccessException {
        this.getShowSQL(sql, null);
        int[] rows = this.jdbcTemplate.batchUpdate(new String[]{sql});
        JdbcBuilder.getCacheInstance().clear();
        return rows;
    }

    public Map<String, Object> call(CallableStatementCreator csc, List<SqlParameter> declaredParameters) {
        return this.jdbcTemplate.call(csc, declaredParameters);
    }

    public <T> T execute(CallableStatementCreator csc, CallableStatementCallback<T> action) {
        return (T)this.jdbcTemplate.execute(csc, action);
    }

    public void execute(String sql) {
        this.getShowSQL(sql, null);
        this.jdbcTemplate.execute(sql);
    }

    private <T> List<T> queryBuilder(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        DefaultCacheSqlProvider sqlProvider = new DefaultCacheSqlProvider(sql, args);
        List result = new ArrayList();
        result = rowMapper != null ? (List)this.jdbcTemplate.query(sql, args, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper)) : this.jdbcTemplate.queryForList(sql, args);
        if (this.useLocalCache) {
            CacheKey cacheKey = this.getCachekeyBuilder(sqlProvider).createCachekey();
            Object cacheObject = JdbcBuilder.getCacheInstance().getOject(cacheKey);
            if (cacheObject == null) {
                this.getShowSQL(sql, args);
                List object = result;
                JdbcBuilder.getCacheInstance().putObject(cacheKey, object);
                return object;
            }
            return (List)cacheObject;
        }
        this.getShowSQL(sql, args);
        return result;
    }

    private <T> T selectOne(String sql, RowMapper<T> rowMapper, Class<T> requiredType, int[] argTypes, Object ... args) throws DataAccessException {
        Object result = null;
        result = rowMapper != null ? this.jdbcTemplate.queryForObject(sql, args, rowMapper) : (requiredType != null ? this.jdbcTemplate.queryForObject(sql, requiredType, args) : (argTypes != null ? this.jdbcTemplate.queryForObject(sql, args, argTypes, rowMapper) : this.jdbcTemplate.queryForMap(sql, args)));
        if (this.useLocalCache) {
            DefaultCacheSqlProvider sqlProvider = new DefaultCacheSqlProvider(sql, args);
            CacheKey cacheKey = this.getCachekeyBuilder(sqlProvider).createCachekey();
            Object cacheObject = JdbcBuilder.getCacheInstance().getOject(cacheKey);
            if (cacheObject != null) {
                return (T)cacheObject;
            }
            this.getShowSQL(sql, args);
            Object object = result;
            JdbcBuilder.getCacheInstance().putObject(cacheKey, object);
            return (T)object;
        }
        this.getShowSQL(sql, args);
        return (T)result;
    }

    public void clear() {
        JdbcBuilder.getCacheInstance().clear();
    }

    private void getShowSQL(String sql, Object[] parameters) {
        if (this.showSQL || this.logger.isDebugEnabled()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("==> SQL:[ " + sql + " ]"));
            } else {
                this.logger.info((Object)("==> SQL:[ " + sql + " ]"));
            }
            this.getParameters(parameters);
        }
    }

    protected void getParameters(Object[] parameters) {
        String params = "";
        if (parameters != null && parameters.length > 0) {
            for (Object parameter : parameters) {
                params = params + parameter + ",";
            }
            params = params.substring(0, params.length() - 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("==> parameters: " + params + " "));
            } else {
                this.logger.info((Object)("==> parameters: " + params + " "));
            }
        }
    }
}

