/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.metadata.ValueElement;
import com.xphsc.easyjdbc.core.transform.setter.ValueBatchSetter;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Jdbcs;
import java.util.LinkedList;
import java.util.List;

public class BatchUpdateExecutor
extends AbstractExecutor<int[]> {
    private final LinkedList persistents = new LinkedList();
    private final SQL sqlBuilder = SQL.BUILD();
    private List<LinkedList<ValueElement>> batchValueElements;

    public <S> BatchUpdateExecutor(LambdaSupplier<S> jdbcBuilder, List<?> persistents) {
        super(jdbcBuilder);
        this.persistents.addAll(persistents);
    }

    @Override
    public void prepare() {
        Class<?> persistentClass = this.persistents.get(0).getClass();
        this.checkEntity(persistentClass);
        EntityElement entityElement = ElementResolver.resolve(persistentClass);
        this.batchValueElements = new LinkedList<LinkedList<ValueElement>>();
        this.sqlBuilder.UPDATE(entityElement.getTable());
        for (FieldElement fieldElement : entityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField() || fieldElement.isPrimaryKey()) continue;
            this.sqlBuilder.SET(fieldElement.getColumn() + " = ?");
        }
        this.sqlBuilder.WHERE(entityElement.getPrimaryKey().getColumn() + " = ?");
        for (FieldElement persistent : this.persistents) {
            LinkedList<ValueElement> valueElements = new LinkedList<ValueElement>();
            Object primaryKeyValue = null;
            for (FieldElement fieldElement : entityElement.getFieldElements().values()) {
                if (fieldElement.isTransientField()) continue;
                if (fieldElement.isPrimaryKey()) {
                    primaryKeyValue = Jdbcs.invokeMethod(persistent, fieldElement.getReadMethod(), "entity\uff1a" + entityElement.getName() + " Primary key\uff1a" + fieldElement.getName() + " Failure to obtain value", new Object[0]);
                    Assert.notNull(primaryKeyValue, "entity:" + entityElement.getName() + ", Primary key cannot be empty");
                    continue;
                }
                Object value = Jdbcs.invokeMethod(persistent, fieldElement.getReadMethod(), "entity\uff1a" + entityElement.getName() + " field\uff1a" + fieldElement.getName() + " Failure to obtain value", new Object[0]);
                if (null == value) continue;
                valueElements.add(new ValueElement(value, fieldElement.isClob(), fieldElement.isBlob()));
            }
            valueElements.add(new ValueElement(primaryKeyValue, Boolean.FALSE, Boolean.FALSE));
            this.batchValueElements.add(valueElements);
        }
    }

    @Override
    protected int[] doExecute() throws JdbcDataException {
        String sql = this.sqlBuilder.toString();
        return this.jdbcBuilder.batchUpdate(sql, new ValueBatchSetter(LOBHANDLER, this.batchValueElements));
    }
}

