/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor;

import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.DynamicEntityElement;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.transform.DynamicEntityRowMapper;
import com.xphsc.easyjdbc.core.transform.EntityRowMapper;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.page.PageRowBounds;
import java.util.Map;

public class FindExecutor<E>
extends AbstractExecutor<E> {
    private final String dialectName;
    private final Class<?> persistentClass;
    private final String sql;
    private final Integer startRow;
    private final Integer limit;
    private final Map<String, String> dynamicMappings;
    private final Object[] parameters;
    private String querySql;
    private EntityElement entityElement;
    private DynamicEntityElement dynamicEntityElement;
    private boolean dynamic;

    public <S> FindExecutor(LambdaSupplier<S> jdbcBuilder, String dialectName, Class<?> persistentClass, String sql) {
        this(jdbcBuilder, dialectName, persistentClass, sql, null, null, null, null);
    }

    public <S> FindExecutor(LambdaSupplier<S> jdbcBuilder, String dialectName, Class<?> persistentClass, String sql, Object[] parameters) {
        this(jdbcBuilder, dialectName, persistentClass, sql, parameters, null, null, null);
    }

    public <S> FindExecutor(LambdaSupplier<S> jdbcTemplate, String dialectName, Class<?> persistentClass, String sql, Object[] parameters, Map<String, String> dynamicMappings, Integer startRow, Integer limit) {
        super(jdbcTemplate);
        this.dialectName = dialectName;
        this.persistentClass = persistentClass;
        this.sql = sql;
        this.parameters = parameters;
        this.dynamicMappings = dynamicMappings;
        this.startRow = startRow;
        this.limit = limit;
    }

    public <S> FindExecutor(LambdaSupplier<S> jdbcTemplate, String dialectName, Class<?> persistentClass, String sql, Object[] parameters, Map<String, String> dynamicMappings, PageInfo page) {
        super(jdbcTemplate);
        this.dialectName = dialectName;
        this.persistentClass = persistentClass;
        this.sql = sql;
        this.parameters = parameters;
        this.dynamicMappings = dynamicMappings;
        this.startRow = page.getPageNum() >= 1 && page.getOffset() == -1 ? (page.getPageNum() - 1) * page.getPageSize() : page.getOffset();
        this.limit = page.getPageNum() >= 1 && page.getOffset() == -1 ? page.getPageSize() : page.getLimit();
    }

    @Override
    public void prepare() {
        if (this.isEntity(this.persistentClass)) {
            this.dynamic = false;
            this.entityElement = ElementResolver.resolve(this.persistentClass);
        } else {
            this.dynamic = true;
            this.dynamicEntityElement = ElementResolver.resolveDynamic(this.persistentClass, this.dynamicMappings);
        }
        this.querySql = null != this.startRow && -1 != this.startRow && null != this.limit && this.limit > 0 ? PageRowBounds.pagination(this.dialectName, this.sql, this.startRow, this.limit) : this.sql;
    }

    @Override
    protected E doExecute() throws JdbcDataException {
        Object rowMapper = null;
        rowMapper = this.dynamic ? new DynamicEntityRowMapper(LOBHANDLER, this.dynamicEntityElement, this.persistentClass) : new EntityRowMapper(LOBHANDLER, this.entityElement, this.persistentClass);
        if (null == this.parameters || this.parameters.length == 0) {
            return (E)this.jdbcBuilder.query(this.querySql, rowMapper);
        }
        return (E)this.jdbcBuilder.query(this.querySql, this.parameters, rowMapper);
    }
}

