/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.transform.EntityRowMapper;
import com.xphsc.easyjdbc.executor.AbstractExecutor;

public class GetExecutor<T>
extends AbstractExecutor<T> {
    private final Class<?> persistentClass;
    private final Object primaryKeyValue;
    private final SQL sqlBuilder = SQL.BUILD();
    private EntityElement entityElement;

    public <S> GetExecutor(LambdaSupplier<S> jdbcBuilder, Class<?> persistentClass, Object primaryKeyValue) {
        super(jdbcBuilder);
        this.persistentClass = persistentClass;
        this.primaryKeyValue = primaryKeyValue;
    }

    @Override
    public void prepare() {
        this.checkEntity(this.persistentClass);
        this.entityElement = ElementResolver.resolve(this.persistentClass);
        this.sqlBuilder.FROM(this.entityElement.getTable());
        for (FieldElement fieldElement : this.entityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField()) continue;
            this.sqlBuilder.SELECT(fieldElement.getColumn());
        }
        this.sqlBuilder.WHERE(this.entityElement.getPrimaryKey().getColumn() + " = ?");
    }

    @Override
    protected T doExecute() throws JdbcDataException {
        String sql = this.sqlBuilder.toString();
        return this.jdbcBuilder.queryForObject(sql, new EntityRowMapper(LOBHANDLER, this.entityElement, this.persistentClass), this.primaryKeyValue);
    }
}

