/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.metadata.ValueElement;
import com.xphsc.easyjdbc.core.metadata.type.FillDateTypeHandler;
import com.xphsc.easyjdbc.core.metadata.version.DefaultVersion;
import com.xphsc.easyjdbc.core.transform.setter.ValueSetter;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Jdbcs;
import java.util.LinkedList;

public class UpdateExecutor
extends AbstractExecutor<Integer> {
    private final Object persistent;
    private final boolean ignoreNull;
    private final SQL sqlBuilder = SQL.BUILD();
    private LinkedList<ValueElement> valueElements;

    public <S> UpdateExecutor(LambdaSupplier<S> jdbcBuilder, Object persistent, boolean ignoreNull) {
        super(jdbcBuilder);
        this.persistent = persistent;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void prepare() {
        this.checkEntity(this.persistent.getClass());
        EntityElement entityElement = ElementResolver.resolve(this.persistent.getClass());
        this.valueElements = new LinkedList();
        this.sqlBuilder.UPDATE(entityElement.getTable());
        FieldElement primaryKey = entityElement.getPrimaryKey();
        Object primaryKeyValue = Jdbcs.invokeMethod(this.persistent, primaryKey.getReadMethod(), "entity\uff1a" + entityElement.getName() + " Primary key\uff1a" + primaryKey.getName() + " Failure to obtain value", new Object[0]);
        Assert.notNull(primaryKeyValue, "entity:" + entityElement.getName() + ", Primary key cannot be empty");
        FieldElement version = entityElement.getVersion();
        Object versionValue = null;
        if (version != null) {
            versionValue = Jdbcs.invokeMethod(this.persistent, version.getReadMethod(), "entity\uff1a" + entityElement.getName() + " version\uff1a" + version.getName() + " Failure to obtain value", new Object[0]);
        }
        for (FieldElement fieldElement : entityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField() || fieldElement.isPrimaryKey()) continue;
            Object value = Jdbcs.invokeMethod(this.persistent, fieldElement.getReadMethod(), "entity\uff1a" + entityElement.getName() + " field\uff1a" + fieldElement.getName() + "Failure to obtain value", new Object[0]);
            if (this.ignoreNull && null == value) continue;
            if (fieldElement.isModifieDateField()) {
                value = FillDateTypeHandler.fillDate(fieldElement);
            }
            if (fieldElement.isVersion()) {
                DefaultVersion nextVersion = new DefaultVersion();
                Object newVersion = nextVersion.nextVersion(versionValue);
                if (newVersion == null) continue;
                this.sqlBuilder.SET(version.getColumn() + "=" + newVersion);
                continue;
            }
            this.sqlBuilder.SET(fieldElement.getColumn() + " = ?");
            this.valueElements.add(new ValueElement(value, fieldElement.isClob(), fieldElement.isBlob()));
        }
        this.sqlBuilder.WHERE(primaryKey.getColumn() + " = ?");
        this.valueElements.add(new ValueElement(primaryKeyValue, primaryKey.isClob(), primaryKey.isBlob()));
        if (versionValue != null) {
            this.sqlBuilder.WHERE(version.getColumn() + " = ?");
            this.valueElements.add(new ValueElement(versionValue, primaryKey.isClob(), primaryKey.isBlob()));
        }
    }

    @Override
    protected Integer doExecute() throws JdbcDataException {
        String sql = this.sqlBuilder.toString();
        return this.jdbcBuilder.update(sql, new ValueSetter(LOBHANDLER, this.valueElements));
    }
}

