/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor.example;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.parser.DefaultSQLParser;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import com.xphsc.easyjdbc.util.Assert;

public class CountByExampleExecutor
extends AbstractExecutor<Long> {
    private String querySql;
    private SQL sqlBuilder;
    private Object[] parameters;

    public <S> CountByExampleExecutor(SQL sqlBuilder, LambdaSupplier<S> jdbcBuilder, Object[] parameters) {
        super(jdbcBuilder);
        this.sqlBuilder = sqlBuilder;
        this.parameters = parameters;
    }

    @Override
    public void prepare() {
        Assert.isTrue(!this.sqlBuilder.toString().contains("GROUP BY"), "The current SQL statement contains the default count (1) aggregate function, and there must be no GROUP BY!");
        if (!this.sqlBuilder.toString().startsWith("SELECT COUNT")) {
            String countRexp = "(?i)^select (?:(?!select|from)[\\s\\S])*(\\(select (?:(?!from)[\\s\\S])* from [^\\)]*\\)(?:(?!select|from)[^\\(])*)*from";
            String replacement = "SELECT COUNT(1) AS COUNT FROM";
            this.querySql = this.sqlBuilder.toString().replaceFirst(countRexp, replacement);
        } else {
            this.querySql = this.sqlBuilder.toString();
        }
        DefaultSQLParser sqlParser = new DefaultSQLParser();
        if (sqlParser.hasOrders(this.querySql).booleanValue()) {
            this.querySql = sqlParser.removeOrders(this.querySql);
        }
    }

    @Override
    protected Long doExecute() throws JdbcDataException {
        if (null == this.parameters || this.parameters.length == 0) {
            return this.jdbcBuilder.queryForObject(this.querySql, Long.class, new Object[0]);
        }
        return this.jdbcBuilder.queryForObject(this.querySql, this.parameters, Long.class);
    }
}

