/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor.example;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import com.xphsc.easyjdbc.util.Assert;

public class DeleteByExampleExecutor
extends AbstractExecutor<Integer> {
    private SQL sqlBuilder;
    private final Class<?> persistentClass;
    private Object[] parameters;

    public <S> DeleteByExampleExecutor(LambdaSupplier<S> jdbcBuilder, SQL applyWhere, Object[] parameters, Class<?> persistentClass) {
        super(jdbcBuilder);
        this.sqlBuilder = applyWhere;
        this.persistentClass = persistentClass;
        this.parameters = parameters;
    }

    @Override
    public void prepare() {
        this.checkEntity(this.persistentClass);
        EntityElement entityElement = ElementResolver.resolve(this.persistentClass);
        this.sqlBuilder.DELETE_FROM(entityElement.getTable());
    }

    @Override
    protected Integer doExecute() throws JdbcDataException {
        String sql = this.sqlBuilder.toString();
        Assert.isTrue(sql.contains("WHERE"), "Delete must have where condition!");
        return this.jdbcBuilder.update(sql, this.parameters);
    }
}

