/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor.example;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.DynamicEntityElement;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.transform.DynamicEntityRowMapper;
import com.xphsc.easyjdbc.core.transform.EntityRowMapper;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.page.PageRowBounds;
import com.xphsc.easyjdbc.util.Collects;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FindByExampleExecutor<T>
extends AbstractExecutor<T> {
    private final Class<?> persistentClass;
    private SQL sqlBuilder;
    private EntityElement entityElement;
    private EntityElement newEntityElement;
    private Integer startRow;
    private Integer limit;
    private String dialectName;
    private DynamicEntityElement dynamicEntityElement;
    private boolean isDynamic;
    private Map<String, String> dynamicMappings;
    protected boolean distinct = false;
    protected LinkedList<String> excludePropertys;
    protected LinkedList<String> selectPropertys;
    private Object[] parameters;

    public <S> FindByExampleExecutor(SQL applyWhere, Class<?> persistentClass, Class<?> entityClass, PageInfo pageInfo, EntityElement entityElement, LinkedList<String> excludePropertys, Map<String, String> mappings, boolean distinct, LinkedList<String> selectPropertys, Object[] parameters, LambdaSupplier<S> jdbcBuilder, String dialectName) {
        super(jdbcBuilder);
        this.sqlBuilder = applyWhere;
        Class<?> clazz = this.persistentClass = entityClass == null ? persistentClass : entityClass;
        if (pageInfo != null) {
            this.startRow = (pageInfo.getPageNum() - 1) * pageInfo.pageSize;
            this.limit = pageInfo.pageSize;
        }
        this.dialectName = dialectName;
        this.excludePropertys = excludePropertys;
        this.dynamicMappings = mappings;
        this.distinct = distinct;
        this.newEntityElement = entityElement;
        this.parameters = parameters;
        this.selectPropertys = selectPropertys;
    }

    public <S> FindByExampleExecutor(SQL applyWhere, Class<?> persistentClass, Class<?> entityClass, Integer offset, Integer limit, EntityElement entityElement, LinkedList<String> excludePropertys, Map<String, String> mappings, boolean distinct, LinkedList<String> selectPropertys, Object[] parameters, LambdaSupplier<S> jdbcBuilder, String dialectName) {
        super(jdbcBuilder);
        this.sqlBuilder = applyWhere;
        Class<?> clazz = this.persistentClass = entityClass == null ? persistentClass : entityClass;
        if (offset != null && limit != null) {
            this.startRow = offset;
            this.limit = limit;
        }
        this.dialectName = dialectName;
        this.excludePropertys = excludePropertys;
        this.dynamicMappings = mappings;
        this.distinct = distinct;
        this.newEntityElement = entityElement;
        this.parameters = parameters;
        this.selectPropertys = selectPropertys;
    }

    @Override
    public void prepare() {
        if (this.isEntity(this.persistentClass)) {
            this.isDynamic = false;
            this.entityElement = ElementResolver.resolve(this.persistentClass);
        } else {
            this.isDynamic = true;
            this.dynamicEntityElement = ElementResolver.resolveDynamic(this.persistentClass, this.dynamicMappings);
        }
        List columns = new ArrayList<String>(10);
        if (!this.sqlBuilder.toString().contains(this.newEntityElement.getTable())) {
            this.sqlBuilder.FROM(this.newEntityElement.getTable());
        }
        for (FieldElement fieldElement : this.newEntityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField()) continue;
            columns.add(fieldElement.getColumn());
            if (!Collects.isEmpty(this.excludePropertys) || !Collects.isEmpty(this.selectPropertys)) continue;
            this.buildSQL(fieldElement.getColumn());
        }
        if (Collects.isNotEmpty(this.excludePropertys) && Collects.isEmpty(this.selectPropertys)) {
            columns = Collects.removeAll(columns, this.excludePropertys);
            for (String column : columns) {
                this.buildSQL(column);
            }
        }
        if (Collects.isNotEmpty(this.selectPropertys) && Collects.isEmpty(this.excludePropertys)) {
            for (String column : this.selectPropertys) {
                this.buildSQL(column);
            }
        }
    }

    private SQL buildSQL(String column) {
        if (this.distinct) {
            this.sqlBuilder.SELECT_DISTINCT(column);
        } else {
            this.sqlBuilder.SELECT(column);
        }
        return this.sqlBuilder;
    }

    @Override
    protected T doExecute() throws JdbcDataException {
        Object rowMapper = null;
        String sql = this.sqlBuilder.toString();
        if (null != this.startRow && -1 != this.startRow && null != this.limit && this.limit > 0) {
            sql = PageRowBounds.pagination(this.dialectName, this.sqlBuilder.toString(), this.startRow, this.limit);
        }
        rowMapper = this.isDynamic ? new DynamicEntityRowMapper(LOBHANDLER, this.dynamicEntityElement, this.persistentClass) : new EntityRowMapper(LOBHANDLER, this.entityElement, this.persistentClass);
        if (null == this.parameters || this.parameters.length == 0) {
            return (T)this.jdbcBuilder.query(sql, rowMapper);
        }
        return (T)this.jdbcBuilder.query(sql, this.parameters, rowMapper);
    }
}

