/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor.ids;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.executor.AbstractExecutor;

public class DeleteByIdsExecutor
extends AbstractExecutor<Integer> {
    private final Class<?> persistentClass;
    private final Iterable primaryKeyValues;
    private final SQL sqlBuilder = SQL.BUILD();

    public <S> DeleteByIdsExecutor(LambdaSupplier<S> jdbcBuilder, Class<?> persistentClass, Iterable primaryKeyValues) {
        super(jdbcBuilder);
        this.persistentClass = persistentClass;
        this.primaryKeyValues = primaryKeyValues;
    }

    @Override
    public void prepare() {
        StringBuilder sb = new StringBuilder();
        this.checkEntity(this.persistentClass);
        EntityElement entityElement = ElementResolver.resolve(this.persistentClass);
        this.sqlBuilder.DELETE_FROM(entityElement.getTable());
        sb.append(entityElement.getPrimaryKey().getColumn() + " in ");
        String inValues = "";
        for (Object value : this.primaryKeyValues) {
            inValues = inValues + "'" + value + "',";
        }
        inValues = inValues.substring(0, inValues.length() - 1);
        sb.append(" (" + inValues + ")");
        this.sqlBuilder.WHERE(sb.toString());
    }

    @Override
    protected Integer doExecute() throws JdbcDataException {
        String sql = this.sqlBuilder.toString();
        return this.jdbcBuilder.update(sql, new Object[0]);
    }
}

