/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor.ids;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.transform.EntityRowMapper;
import com.xphsc.easyjdbc.executor.AbstractExecutor;

public class FindByIdsExecutor<T>
extends AbstractExecutor<T> {
    private final Class<?> persistentClass;
    private final Iterable primaryKeyValues;
    private final SQL sqlBuilder = SQL.BUILD();
    private EntityElement entityElement;

    public <S> FindByIdsExecutor(LambdaSupplier<S> jdbcBuilder, Class<?> persistentClass, Iterable values) {
        super(jdbcBuilder);
        this.persistentClass = persistentClass;
        this.primaryKeyValues = values;
    }

    @Override
    public void prepare() {
        StringBuilder sb = new StringBuilder();
        this.checkEntity(this.persistentClass);
        this.entityElement = ElementResolver.resolve(this.persistentClass);
        this.sqlBuilder.FROM(this.entityElement.getTable());
        for (FieldElement fieldElement : this.entityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField()) continue;
            this.sqlBuilder.SELECT(fieldElement.getColumn());
        }
        sb.append(this.entityElement.getPrimaryKey().getColumn() + " in ");
        String inValues = "";
        for (Object value : this.primaryKeyValues) {
            inValues = inValues + "'" + value + "',";
        }
        inValues = inValues.substring(0, inValues.length() - 1);
        sb.append(" (" + inValues + ")");
        this.sqlBuilder.WHERE(sb.toString());
    }

    @Override
    protected T doExecute() throws JdbcDataException {
        String sql = this.sqlBuilder.toString();
        return (T)this.jdbcBuilder.query(sql, new EntityRowMapper(LOBHANDLER, this.entityElement, this.persistentClass));
    }
}

