/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Beans {
    public static Map<String, Object> beanToMap(Object bean) {
        PropertyDescriptor[] descriptors;
        if (bean == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> beanMap = new HashMap<String, Object>();
        for (PropertyDescriptor descriptor : descriptors = Beans.getPropertyDescriptors(bean)) {
            String name = descriptor.getName();
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null) continue;
            try {
                beanMap.put(name, readMethod.invoke(bean, new Object[0]));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return beanMap;
    }

    public static TreeMap<String, Object> beanToTreeMap(Object bean) {
        PropertyDescriptor[] descriptors;
        if (bean == null) {
            return new TreeMap<String, Object>();
        }
        TreeMap<String, Object> beanMap = new TreeMap<String, Object>();
        for (PropertyDescriptor descriptor : descriptors = Beans.getPropertyDescriptors(bean)) {
            String name = descriptor.getName();
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null) continue;
            try {
                beanMap.put(name, readMethod.invoke(bean, new Object[0]));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return beanMap;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }
}

