/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.util;

import com.xphsc.easyjdbc.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.objenesis.Objenesis;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

public class Jdbcs {
    private static final Objenesis OBJENESIS = new ObjenesisStd();
    private static final ConcurrentHashMap<String, ObjectInstantiator<?>> INSTANTIATORS = new ConcurrentHashMap();

    public static Set<Field> getFields(Class<?> cls, Set<Class<?>> superclass) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> type : superclass) {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
        }
        fields.addAll(Arrays.asList(cls.getDeclaredFields()));
        return Collections.unmodifiableSet(fields);
    }

    public static Method getReadMethod(Class<?> cls, Set<Class<?>> superclass, String fieldName, Class<?> ... parameterTypes) {
        HashSet classes = new HashSet();
        classes.add(cls);
        classes.addAll(superclass);
        String methodName = "get" + StringUtil.capitalize(fieldName);
        Method method = Jdbcs.getMethod(classes, methodName, parameterTypes);
        if (null == method) {
            methodName = "is" + StringUtil.capitalize(fieldName);
            method = Jdbcs.getMethod(classes, methodName, parameterTypes);
        }
        return method;
    }

    public static Method getWriteMethod(Class<?> cls, Set<Class<?>> superclass, String fieldName, Class<?> ... parameterTypes) {
        HashSet classes = new HashSet();
        classes.add(cls);
        classes.addAll(superclass);
        String methodName = "set" + StringUtil.capitalize(fieldName);
        return Jdbcs.getMethod(classes, methodName, parameterTypes);
    }

    public static Method getMethod(Set<Class<?>> classes, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> i : classes) {
            try {
                Method method = i.getDeclaredMethod(methodName, parameterTypes);
                if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, Method method, String errorMsg, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(errorMsg, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(errorMsg, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(errorMsg, e);
        }
    }

    public static <T> T newInstance(Class<?> cls) {
        if (cls.isInterface()) {
            throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684\u7c7b\u578b");
        }
        if (INSTANTIATORS.contains(cls.getName())) {
            return (T)INSTANTIATORS.get(cls.getName()).newInstance();
        }
        ObjectInstantiator instantiator = OBJENESIS.getInstantiatorOf(cls);
        INSTANTIATORS.putIfAbsent(cls.getName(), instantiator);
        return (T)instantiator.newInstance();
    }

    public static String camelToUnderline(String fieldName) {
        int len = fieldName.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_");
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Object getResultValue(ResultSet rs, int columnIndex, int jdbcType, Class<?> type) throws SQLException {
        String typeName = type.getName();
        if ("java.math.BigDecimal".equals(typeName)) {
            return rs.getBigDecimal(columnIndex);
        }
        if ("java.math.BigInteger".equals(typeName)) {
            BigDecimal bigDecimal = rs.getBigDecimal(columnIndex);
            return bigDecimal == null ? null : bigDecimal.toBigInteger();
        }
        if ("boolean".equals(typeName)) {
            return rs.getBoolean(columnIndex);
        }
        if ("java.lang.Boolean".equals(typeName)) {
            return rs.getBoolean(columnIndex);
        }
        if ("byte".equals(typeName)) {
            return rs.getByte(columnIndex);
        }
        if ("java.lang.Byte".equals(typeName)) {
            return rs.getByte(columnIndex);
        }
        if ("char".equals(typeName)) {
            String columnValue = rs.getString(columnIndex);
            if (columnValue != null) {
                return Character.valueOf(columnValue.charAt(0));
            }
            return null;
        }
        if ("java.lang.Character".equals(typeName)) {
            String columnValue = rs.getString(columnIndex);
            if (columnValue != null) {
                return Character.valueOf(columnValue.charAt(0));
            }
            return null;
        }
        if ("java.util.Date".equals(typeName)) {
            if (91 == jdbcType) {
                Date sqlDate = rs.getDate(columnIndex);
                if (sqlDate != null) {
                    return new java.util.Date(sqlDate.getTime());
                }
                return null;
            }
            if (93 == jdbcType) {
                Timestamp sqlTimestamp = rs.getTimestamp(columnIndex);
                if (sqlTimestamp != null) {
                    return new java.util.Date(sqlTimestamp.getTime());
                }
                return null;
            }
            if (92 == jdbcType) {
                Time sqlTime = rs.getTime(columnIndex);
                if (sqlTime != null) {
                    return new java.util.Date(sqlTime.getTime());
                }
                return null;
            }
        }
        if ("java.time.LocalDate".equals(typeName)) {
            if (91 == jdbcType) {
                Date sqlDate = rs.getDate(columnIndex);
                return sqlDate.toLocalDate();
            }
            if (93 == jdbcType) {
                Timestamp timestamp = rs.getTimestamp(columnIndex);
                return timestamp.toLocalDateTime().toLocalDate();
            }
            Date sqlDate = rs.getDate(columnIndex);
            return sqlDate.toLocalDate();
        }
        if ("java.time.LocalDateTime".equals(typeName)) {
            if (93 == jdbcType) {
                Timestamp timestamp = rs.getTimestamp(columnIndex);
                return timestamp.toLocalDateTime();
            }
            Date sqlDate = rs.getDate(columnIndex);
            Time time = rs.getTime(columnIndex);
            if (sqlDate != null && time != null) {
                return time.toLocalTime().atDate(sqlDate.toLocalDate());
            }
        }
        if ("java.time.LocalTime".equals(typeName) && 92 == jdbcType) {
            Time sqlTime = rs.getTime(columnIndex);
            if (sqlTime != null) {
                return sqlTime.toLocalTime();
            }
            if (93 == jdbcType) {
                Timestamp timestamp = rs.getTimestamp(columnIndex);
                return timestamp.toLocalDateTime().toLocalTime();
            }
            Time sqlTimes = rs.getTime(columnIndex);
            return sqlTimes.toLocalTime();
        }
        if ("double".equals(typeName)) {
            return rs.getDouble(columnIndex);
        }
        if ("java.lang.Double".equals(typeName)) {
            if (null != rs.getObject(columnIndex)) {
                return rs.getDouble(columnIndex);
            }
            return null;
        }
        if ("float".equals(typeName)) {
            return Float.valueOf(rs.getFloat(columnIndex));
        }
        if ("java.lang.Float".equals(typeName)) {
            if (null != rs.getObject(columnIndex)) {
                return Float.valueOf(rs.getFloat(columnIndex));
            }
            return null;
        }
        if ("int".equals(typeName)) {
            return rs.getInt(columnIndex);
        }
        if ("java.lang.Integer".equals(typeName)) {
            if (null != rs.getObject(columnIndex)) {
                return rs.getInt(columnIndex);
            }
            return null;
        }
        if ("long".equals(typeName)) {
            return rs.getLong(columnIndex);
        }
        if ("java.lang.Long".equals(typeName)) {
            if (null != rs.getObject(columnIndex)) {
                return rs.getLong(columnIndex);
            }
            return null;
        }
        if ("short".equals(typeName)) {
            return rs.getShort(columnIndex);
        }
        if ("java.lang.Short".equals(typeName)) {
            if (null != rs.getObject(columnIndex)) {
                return rs.getShort(columnIndex);
            }
            return null;
        }
        if ("java.sql.Date".equals(typeName)) {
            return rs.getDate(columnIndex);
        }
        if ("java.sql.Timestamp".equals(typeName)) {
            return rs.getTimestamp(columnIndex);
        }
        if ("java.sql.Time".equals(typeName)) {
            return rs.getTime(columnIndex);
        }
        return rs.getObject(columnIndex);
    }
}

