/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.lambda.Reflections;
import com.xphsc.easyjdbc.core.lambda.StringSupplier;
import com.xphsc.easyjdbc.core.support.JdbcBuilder;
import com.xphsc.easyjdbc.executor.CountExecutor;
import com.xphsc.easyjdbc.executor.FindExecutor;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.page.PageInfoImpl;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Collects;
import com.xphsc.easyjdbc.util.StringUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EasyJdbcSelector {
    private final JdbcBuilder jdbcBuilder;
    private final String dialectName;
    private String sql;
    private Integer offset;
    private Integer limit;
    private Class<?> entityClass;
    private PageInfo<?> pageInfo;
    private Map<String, String> mappings;
    private final LinkedList<Object> parameters;
    private final SQL sqlBuilder = SQL.BUILD();

    protected <T> EasyJdbcSelector(LambdaSupplier<T> jdbcBuilder, StringSupplier dialectName) {
        this.jdbcBuilder = (JdbcBuilder)Reflections.classForLambdaSupplier(jdbcBuilder);
        this.dialectName = (String)dialectName.get();
        this.parameters = new LinkedList();
    }

    private EasyJdbcSelector getSelf() {
        return this;
    }

    public EasyJdbcSelector entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this.getSelf();
    }

    public EasyJdbcSelector pageInfo(int pageNum, int pageSize) {
        Assert.isTrue(pageNum >= 1, "PageNum must be greater than or equal to 1");
        Assert.isTrue(pageSize > 0, "PageSize must be greater than 0");
        if (this.pageInfo == null) {
            this.pageInfo = new PageInfo();
        }
        this.pageInfo.pageNum = pageNum;
        this.pageInfo.pageSize = pageSize;
        return this.getSelf();
    }

    public EasyJdbcSelector offsetPage(int offset, int limit) {
        Assert.isTrue(offset >= 0, "Offset must be greater than or equal to 0");
        Assert.isTrue(limit > 0, "Limit must be greater than 0");
        this.offset = offset;
        this.limit = limit;
        return this.getSelf();
    }

    public EasyJdbcSelector mapping(String column, String field) {
        Assert.hasText(column, "The column of the mapping cannot be empty");
        Assert.hasText(field, "Mapping attributes cannot be empty");
        if (this.mappings == null) {
            this.mappings = new HashMap<String, String>();
        }
        this.mappings.put(field, column);
        return this.getSelf();
    }

    public EasyJdbcSelector sql(String sql) {
        this.sql = sql;
        return this.getSelf();
    }

    public EasyJdbcSelector parameter(Object parameter) {
        Assert.notNull(parameter, "Parameters cannot be null");
        this.parameters.add(parameter);
        return this.getSelf();
    }

    public EasyJdbcSelector parameters(Object ... parameters) {
        Assert.notNull(parameters, "Parameters cannot be null");
        for (Object parameter : parameters) {
            this.parameters.add(parameter);
        }
        return this.getSelf();
    }

    @Deprecated
    public EasyJdbcSelector startRow(int startRow) {
        Assert.isTrue(startRow >= 0, "StartRow must be greater than or equal to 0");
        this.offset = startRow;
        return this.getSelf();
    }

    @Deprecated
    public EasyJdbcSelector limit(int limit) {
        Assert.isTrue(limit > 0, "Limit must be greater than 0");
        this.limit = limit;
        return this.getSelf();
    }

    public <T> T get() throws JdbcDataException {
        Assert.notNull(this.entityClass, "Entity type cannot be empty");
        if (StringUtil.isBlank(this.sql)) {
            this.sql = this.sqlBuilder.toString();
        }
        Assert.hasText(this.sql, "SQL statement cannot be empty");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.dialectName, this.entityClass, this.sql, this.parameters.toArray());
        List results = (List)executor.execute();
        executor = null;
        return Collects.isNotEmpty(results) ? (T)results.get(0) : null;
    }

    public <T> Optional<T> getOne() throws JdbcDataException {
        return Optional.ofNullable(this.get());
    }

    public <T> List<T> list() throws JdbcDataException {
        Assert.notNull(this.entityClass, "Entity type cannot be empty");
        if (StringUtil.isBlank(this.sql)) {
            this.sql = this.sqlBuilder.toString();
        }
        Assert.hasText(this.sql, "SQL statement cannot be empty");
        FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.dialectName, this.entityClass, this.sql, this.parameters.toArray(), this.mappings, this.offset, this.limit);
        List results = (List)executor.execute();
        executor = null;
        return results;
    }

    public <T> PageInfo<T> page() throws JdbcDataException {
        Assert.notNull(this.entityClass, "Entity type cannot be empty");
        List results = null;
        long total = 1L;
        if (this.offset == null && this.limit == null) {
            if (this.pageInfo == null) {
                this.pageInfo = new PageInfo();
            }
            if (StringUtil.isBlank(this.sql)) {
                this.sql = this.sqlBuilder.toString();
            }
            Assert.hasText(this.sql, "SQL statement cannot be empty");
            FindExecutor executor = new FindExecutor(this::getJdbcBuilder, this.dialectName, this.entityClass, this.sql, this.parameters.toArray(), this.mappings, this.pageInfo);
            results = (List)executor.execute();
            total = this.count();
            return new PageInfoImpl(results, total, this.pageInfo.getPageNum(), this.pageInfo.getPageSize());
        }
        int pageNum = (int)Math.ceil((this.offset + this.limit) / this.limit);
        int pageSize = this.limit;
        return new PageInfoImpl(results, total, pageNum, pageSize);
    }

    public long count() throws JdbcDataException {
        if (StringUtil.isBlank(this.sql)) {
            this.sql = this.sqlBuilder.toString();
        }
        Assert.hasText(this.sql, "SQL statement cannot be empty");
        CountExecutor executor = new CountExecutor(this::getJdbcBuilder, this.sql, this.parameters.toArray());
        long count = (Long)executor.execute();
        executor = null;
        return count;
    }

    public EasyJdbcSelector SELECT(String columns) {
        this.sqlBuilder.SELECT(columns);
        return this.getSelf();
    }

    public EasyJdbcSelector SELECT_DISTINCT(String columns) {
        this.sqlBuilder.SELECT_DISTINCT(columns);
        return this.getSelf();
    }

    public EasyJdbcSelector FROM(String table) {
        this.sqlBuilder.FROM(table);
        return this.getSelf();
    }

    public EasyJdbcSelector JOIN(String join) {
        this.sqlBuilder.JOIN(join);
        return this.getSelf();
    }

    public EasyJdbcSelector INNER_JOIN(String join) {
        this.sqlBuilder.INNER_JOIN(join);
        return this.getSelf();
    }

    public EasyJdbcSelector LEFT_OUTER_JOIN(String join) {
        this.sqlBuilder.LEFT_OUTER_JOIN(join);
        return this.getSelf();
    }

    public EasyJdbcSelector RIGHT_OUTER_JOIN(String join) {
        this.sqlBuilder.RIGHT_OUTER_JOIN(join);
        return this.getSelf();
    }

    public EasyJdbcSelector OUTER_JOIN(String join) {
        this.sqlBuilder.OUTER_JOIN(join);
        return this.getSelf();
    }

    public EasyJdbcSelector WHERE(String conditions) {
        this.sqlBuilder.WHERE(conditions);
        return this.getSelf();
    }

    public EasyJdbcSelector OR() {
        this.sqlBuilder.OR();
        return this.getSelf();
    }

    public EasyJdbcSelector AND() {
        this.sqlBuilder.AND();
        return this.getSelf();
    }

    public EasyJdbcSelector GROUP_BY(String columns) {
        this.sqlBuilder.GROUP_BY(columns);
        return this.getSelf();
    }

    public EasyJdbcSelector HAVING(String conditions) {
        this.sqlBuilder.HAVING(conditions);
        return this.getSelf();
    }

    public EasyJdbcSelector ORDER_BY(String columns) {
        this.sqlBuilder.ORDER_BY(columns);
        return this.getSelf();
    }

    private JdbcBuilder getJdbcBuilder() {
        return this.jdbcBuilder;
    }
}

