/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.binding;

import com.xphsc.easyjdbc.EasyJdbcTemplate;
import com.xphsc.easyjdbc.annotation.SqlParam;
import com.xphsc.easyjdbc.core.EasyJdbcDao;
import com.xphsc.easyjdbc.core.SimpleJdbcDao;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.SQLOptionType;
import com.xphsc.easyjdbc.core.parser.DefaultSQLOptionTypeParser;
import com.xphsc.easyjdbc.core.processor.AbstractDaoMethodProcessor;
import com.xphsc.easyjdbc.core.processor.AnnotationMethodProcessor;
import com.xphsc.easyjdbc.core.processor.BaseMethodProcessor;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.util.Assert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class DaoMethod {
    private Class<?> modelClass;
    private AbstractDaoMethodProcessor daoMethodProcessor;
    private Method method;
    private Object[] parameters;
    private SimpleJdbcDao simpleJdbcDao = new SimpleJdbcDao();
    private Map<String, Object> sqlParamsMap;
    private PageInfo pageInfo;

    public DaoMethod(Class<?> daoInterface, LambdaSupplier<EasyJdbcTemplate> easyJdbcTemplate, Method method, Object[] parameters) throws Exception {
        ((EasyJdbcTemplate)easyJdbcTemplate.get()).interfaceClass(daoInterface.getName() + "." + method.getName());
        this.modelClass = DaoMethod.getEntityClass(EasyJdbcDao.class, daoInterface);
        this.simpleJdbcDao.easyJdbcTemplate(easyJdbcTemplate);
        this.simpleJdbcDao.modelClass = this.modelClass;
        this.method = method;
        this.parameters = parameters;
    }

    protected Object doExecute() throws Exception {
        Annotation[] annotations = this.method.getAnnotations();
        MethodReturnType methodReturnType = new MethodReturnType(this.method);
        if (methodReturnType.returnsAnnotationType) {
            for (Annotation each : annotations) {
                this.daoMethodProcessor = new AnnotationMethodProcessor();
                if (this.daoMethodProcessor == null) continue;
                this.daoMethodProcessor.setAnnotation(each);
                this.daoMethodProcessor.setParameters(this.parameters);
                this.daoMethodProcessor.setParameterAnnotations(this.method.getParameterAnnotations());
                this.daoMethodProcessor.setSimpleJdbcDao(this.simpleJdbcDao);
                this.daoMethodProcessor.setMethod(this.method);
                this.daoMethodProcessor.setParamsMap(this.initParamsMap(this.method, this.parameters));
                this.daoMethodProcessor.setPersistentClass(this.modelClass);
                return this.daoMethodProcessor.process();
            }
        } else {
            this.daoMethodProcessor = new BaseMethodProcessor();
            this.daoMethodProcessor.setMethod(this.method);
            this.daoMethodProcessor.setParameters(this.parameters);
            this.daoMethodProcessor.setSimpleJdbcDao(this.simpleJdbcDao);
            this.daoMethodProcessor.setPersistentClass(this.modelClass);
            return this.daoMethodProcessor.process();
        }
        return null;
    }

    public static Class getEntityClass(Class commonClass, Class mapperClass) {
        Type[] types;
        for (Type type : types = mapperClass.getGenericInterfaces()) {
            ParameterizedType t;
            if (!(type instanceof ParameterizedType) || !(t = (ParameterizedType)type).getRawType().equals(commonClass) && !commonClass.isAssignableFrom((Class)t.getRawType())) continue;
            Class returnType = (Class)t.getActualTypeArguments()[0];
            return returnType;
        }
        return null;
    }

    public static String[] getMethodParameterNamesByAnnotation(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations == null || parameterAnnotations.length == 0) {
            return null;
        }
        String[] parameterNames = new String[parameterAnnotations.length];
        int i = 0;
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        for (int j = 0; j < n; ++j) {
            Annotation[] parameterAnnotation;
            for (Annotation annotation : parameterAnnotation = annotationArray[j]) {
                if (!(annotation instanceof SqlParam)) continue;
                SqlParam param = (SqlParam)annotation;
                parameterNames[i++] = param.value();
            }
        }
        return parameterNames;
    }

    private Map<String, Object> initParamsMap(Method method, Object[] args) throws Exception {
        this.sqlParamsMap = new HashMap<String, Object>();
        this.pageInfo = new PageInfo();
        if (args != null && args.length >= 1) {
            String[] params = DaoMethod.getMethodParameterNamesByAnnotation(method);
            Assert.isTrue(params.length == args.length, "Method parameter number >= 2, parameter must be used: label @param!");
            if (params != null && params[0] != null) {
                int argsNum = 0;
                for (String v : params) {
                    Assert.notNull(v, "Dao interface definition, parameter using @param tag!");
                    if ("pageNum".equalsIgnoreCase(v)) {
                        this.pageInfo.setPageNum(Integer.parseInt(args[argsNum].toString()));
                    }
                    if ("pageSize".equalsIgnoreCase(v)) {
                        this.pageInfo.setPageSize(Integer.parseInt(args[argsNum].toString()));
                    }
                    this.sqlParamsMap.put(v, args[argsNum]);
                    ++argsNum;
                }
            }
            if (params[0] == null) {
                Class<Object> parameterType = method.getParameterTypes()[0];
                if (parameterType.isAssignableFrom(Map.class)) {
                    this.sqlParamsMap = (Map)args[0];
                }
                if (parameterType.isAssignableFrom(PageInfo.class)) {
                    this.pageInfo = (PageInfo)args[0];
                    if (this.pageInfo != null) {
                        if (this.pageInfo.getPageNum() >= 1 && this.pageInfo.getOffset() == -1) {
                            this.sqlParamsMap.put("pageNum", this.pageInfo.getPageNum());
                        }
                        if (this.pageInfo.getPageSize() > 0) {
                            this.sqlParamsMap.put("pageSize", this.pageInfo.getPageSize());
                        }
                        if (this.pageInfo.getOffset() >= 0) {
                            this.sqlParamsMap.put("offset", this.pageInfo.getOffset());
                        }
                        if (this.pageInfo.getLimit() > 0) {
                            this.sqlParamsMap.put("limit", this.pageInfo.getPageSize());
                        }
                    }
                }
            }
        } else if (args != null && args.length == 1) {
            this.sqlParamsMap.put("POJO", args[0]);
        }
        return this.sqlParamsMap;
    }

    private static class MethodReturnType {
        private boolean returnsAnnotationType;

        public MethodReturnType(Method method) {
            DefaultSQLOptionTypeParser sqlOptionTypeParser = new DefaultSQLOptionTypeParser();
            SQLOptionType sqlOptionType = sqlOptionTypeParser.getSqlCommandType(method);
            if (sqlOptionType.equals((Object)SQLOptionType.SQLINSERT) || sqlOptionType.equals((Object)SQLOptionType.SQLDELETE) || sqlOptionType.equals((Object)SQLOptionType.SQLUPDATE) || sqlOptionType.equals((Object)SQLOptionType.SQLSELECT)) {
                this.returnsAnnotationType = true;
            }
        }
    }
}

