/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.cache;

import com.xphsc.easyjdbc.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CacheKey
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3997169102080140762L;
    private static final int DEFAULT_MULTIPLYER = 37;
    private static final int DEFAULT_HASHCODE = 17;
    private final int multiplyer;
    private int hashcode = 17;
    private int checksum;
    private int count = 0;
    private List<Object> updateList = new ArrayList<Object>();

    public CacheKey() {
        this.multiplyer = 37;
    }

    public CacheKey(Object ... objects) {
        this();
        this.updateAll(objects);
    }

    public int getUpdateList() {
        return this.updateList.size();
    }

    public void update(Object object) {
        int baseHashcode = object == null ? 1 : StringUtil.hashcode(object);
        ++this.count;
        this.checksum += baseHashcode;
        this.hashcode = this.multiplyer * this.hashcode + (baseHashcode *= this.count);
        this.updateList.add(object);
    }

    public void updateAll(Object[] objects) {
        for (Object object : objects) {
            this.update(object);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CacheKey)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CacheKey cacheKey = (CacheKey)obj;
        if (this.hashcode != cacheKey.hashcode) {
            return false;
        }
        if (this.checksum != cacheKey.checksum) {
            return false;
        }
        if (this.count != cacheKey.count) {
            return false;
        }
        int l = this.updateList.size();
        for (int i = 0; i < l; ++i) {
            if (Objects.equals(this.updateList.get(i), cacheKey.updateList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashcode;
    }

    protected CacheKey clone() throws CloneNotSupportedException {
        CacheKey cloneCacheKey = (CacheKey)super.clone();
        cloneCacheKey.updateList = new ArrayList<Object>(this.updateList);
        return cloneCacheKey;
    }

    public String toString() {
        StringBuilder returnValue = new StringBuilder().append(this.hashcode).append(':').append(this.checksum);
        for (Object object : this.updateList) {
            returnValue.append(':').append(object.toString());
        }
        return returnValue.toString();
    }
}

