/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.entity;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.entity.Aggregation;
import com.xphsc.easyjdbc.core.entity.Example;
import com.xphsc.easyjdbc.core.entity.LikeType;
import com.xphsc.easyjdbc.core.entity.Sorts;
import com.xphsc.easyjdbc.core.exception.EasyJdbcException;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.support.JdbcBuilder;
import com.xphsc.easyjdbc.executor.example.CountByExampleExecutor;
import com.xphsc.easyjdbc.executor.example.DeleteByExampleExecutor;
import com.xphsc.easyjdbc.executor.example.FindByExampleExecutor;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.page.PageInfoImpl;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Collects;
import com.xphsc.easyjdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;

public abstract class AbstractExample<T> {
    protected SQL sqlBuilder = SQL.BUILD();
    protected Sorts orderByClause;
    protected boolean distinct;
    protected List<Example.Criteria> oredCriteria;
    protected Class<?> entityClass;
    protected Class<?> persistentClass;
    protected PageInfo pageInfo;
    private Integer offset;
    private Integer limit;
    protected LinkedList<String> excludePropertys;
    protected EntityElement entityElement;
    protected Map<String, String> mappings;
    public JdbcBuilder jdbcBuilder;
    public String dialectName;
    protected LinkedList<Object> parameters;
    protected LinkedList<String> selectPropertys;
    protected LinkedList<String> groupByClause;
    protected Boolean isAggregate = false;
    protected List<Criterion> criteria;

    protected T mapping(String property, String field) {
        Assert.hasText(this.checkProperty(property).getColumn(), "The column of the mapping cannot be empty");
        Assert.hasText(field, "Mapping attributes cannot be empty");
        if (Collects.isEmpty(this.mappings)) {
            this.mappings = new HashMap<String, String>();
        }
        this.mappings.put(field, this.checkProperty(property).getColumn());
        return (T)this;
    }

    public T isDistinct(boolean distinct) {
        this.distinct = distinct;
        return (T)this;
    }

    public T orderByClause(Sorts sorts) {
        this.orderByClause = sorts;
        return (T)this;
    }

    public T entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return (T)this;
    }

    public T pageInfo(int pageNum, int pageSize) {
        Assert.isTrue(pageNum >= 1, "PageNum must be greater than or equal to 1");
        Assert.isTrue(pageSize > 0, "PageSize must be greater than 0");
        if (this.pageInfo == null) {
            this.pageInfo = new PageInfo();
        }
        this.pageInfo.pageNum = pageNum;
        this.pageInfo.pageSize = pageSize;
        return (T)this;
    }

    public T offsetPage(int offset, int limit) {
        Assert.isTrue(offset >= 0, "Offset must be greater than or equal to 0");
        Assert.isTrue(limit > 0, "Limit must be greater than 0");
        this.offset = offset;
        this.limit = limit;
        return (T)this;
    }

    protected T excludePropertys(String ... excludePropertys) {
        LinkedList<String> columns = new LinkedList<String>();
        for (String property : excludePropertys) {
            columns.add(this.checkProperty(property).getColumn());
        }
        this.excludePropertys = columns;
        return (T)this;
    }

    protected T selectPropertys(String ... propertys) {
        LinkedList<String> columns = new LinkedList<String>();
        for (String property : propertys) {
            columns.add(this.checkProperty(property).getColumn());
        }
        this.selectPropertys = columns;
        return (T)this;
    }

    protected T selectPropertys(Aggregation aggregation, String ... propertys) {
        LinkedList<String> columns = new LinkedList<String>();
        if (Collects.isEmpty(this.mappings)) {
            this.mappings = new HashMap<String, String>();
        }
        for (Aggregation.Aggregate aggregate : aggregation.getAggregates()) {
            if (aggregate.getAsProperty() != null) {
                columns.add(aggregate.getAggregateType().name() + "(" + this.checkProperty(aggregate.getProperty()).getColumn() + ") AS " + aggregate.getAsProperty());
                this.mappings.put(aggregate.getAsProperty(), aggregate.getAsProperty());
                continue;
            }
            columns.add(aggregate.getAggregateType().name() + "(" + this.checkProperty(aggregate.getProperty()).getColumn() + ")  ");
        }
        for (String property : propertys) {
            columns.add(this.checkProperty(property).getColumn() + " AS " + this.checkProperty(property).getName());
            this.mappings.put(this.checkProperty(property).getName(), this.checkProperty(property).getName());
        }
        this.selectPropertys = columns;
        this.isAggregate = true;
        return (T)this;
    }

    protected T groupByClause(String ... groupBys) {
        LinkedList<String> groupByClause = new LinkedList<String>();
        for (String groupBy : groupBys) {
            groupByClause.add(groupBy);
        }
        this.groupByClause = groupByClause;
        return (T)this;
    }

    protected void addCriterion(String condition) {
        if (condition == null) {
            try {
                throw new EasyJdbcException("Value for condition cannot be null");
            }
            catch (EasyJdbcException e) {
                e.printStackTrace();
            }
        }
        if (condition.startsWith("null")) {
            return;
        }
        this.criteria.add(new Criterion(condition));
    }

    protected void addOrCriterion(String condition) {
        if (condition == null) {
            throw new EasyJdbcException("Value for condition cannot be null");
        }
        if (!condition.startsWith("null")) {
            this.criteria.add(new Criterion(condition, true));
        }
    }

    protected void addCriterion(String condition, Object value) {
        if (value == null) {
            return;
        }
        this.criteria.add(new Criterion(condition, value));
    }

    protected void addCriterion(String property, String condition, Object value) {
        if (value == null) {
            throw new EasyJdbcException("Value for " + property + " cannot be null");
        }
        condition = this.isAggregate != false ? property + " " + condition : this.checkProperty(property).getColumn() + " " + condition;
        this.criteria.add(new Criterion(condition, value, false));
    }

    protected void addOrCriterion(String property, String condition, Object value) {
        if (value == null) {
            throw new EasyJdbcException("Value for " + property + " cannot be null");
        }
        condition = this.isAggregate != false ? property + " " + condition : this.checkProperty(property).getColumn() + " " + condition;
        this.criteria.add(new Criterion(condition, value, true));
    }

    protected void addCriterion(String property, String condition, Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            throw new EasyJdbcException("Between values for " + property + " cannot be null");
        }
        condition = this.isAggregate != false ? property + " " + condition : this.checkProperty(property).getColumn() + " " + condition;
        this.criteria.add(new Criterion(condition, value1, value2, false));
    }

    protected void addOrCriterion(String property, String condition, Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            throw new EasyJdbcException("Between values for " + property + " cannot be null");
        }
        condition = this.isAggregate != false ? property + " " + condition : this.checkProperty(property).getColumn() + " " + condition;
        this.criteria.add(new Criterion(condition, value1, value2, true));
    }

    protected void addCriterionLike(String property, Object value, LikeType likeType, boolean islike) {
        String like;
        String string = like = islike ? "like" : "not like";
        if (StringUtil.isNotBlank(likeType.getType())) {
            switch (likeType.getType()) {
                case "left": {
                    this.addCriterion(property, like, value + "%");
                    break;
                }
                case "right": {
                    this.addCriterion(property, like, "%" + value);
                    break;
                }
                case "custom": {
                    this.addCriterion(property, like, value);
                    break;
                }
                case "default": {
                    this.addCriterion(property, like, "%" + value + "%");
                    break;
                }
            }
        }
    }

    protected void addOrCriterionLike(String property, Object value, LikeType likeType, boolean islike) {
        String like;
        String string = like = islike ? "like" : "not like";
        if (StringUtil.isNotBlank(likeType.getType())) {
            switch (likeType.getType()) {
                case "left": {
                    this.addOrCriterion(property, like, value + "%");
                    break;
                }
                case "right": {
                    this.addOrCriterion(property, like, "%" + value);
                    break;
                }
                case "custom": {
                    this.addOrCriterion(property, like, value);
                    break;
                }
                case "default": {
                    this.addOrCriterion(property, like, "%" + value + "%");
                    break;
                }
            }
        }
    }

    protected SQL applyWhere() {
        List<Sorts.Order> orderList;
        List<Example.Criteria> newOredCriteria = null;
        newOredCriteria = this.oredCriteria;
        StringBuilder sb = new StringBuilder();
        boolean firstCriteria = true;
        if (!newOredCriteria.isEmpty()) {
            for (int i = 0; i < newOredCriteria.size(); ++i) {
                Object var5_8 = null;
                Example.Criteria criteria = newOredCriteria.get(i);
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" " + criteria.andOr + " ");
                }
                List list = criteria.getCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < list.size(); ++j) {
                    Criterion criterion = (Criterion)list.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" ");
                        sb.append(" " + criterion.andOr + " ");
                    }
                    sb.append(" ");
                    if (criterion.getCondition().trim().endsWith("in") || criterion.noValue) {
                        sb.append(criterion.getCondition());
                    } else {
                        sb.append(criterion.getCondition() + " ?");
                    }
                    if (criterion.getValue() == null) continue;
                    if (criterion.isListValue()) {
                        String inValues = "";
                        List list2 = (List)criterion.getValue();
                        for (Object value : list2) {
                            inValues = inValues + "'" + value + "',";
                        }
                        inValues = inValues.substring(0, inValues.length() - 1);
                        sb.append(" (" + inValues + ")");
                    }
                    if (criterion.betweenValue) {
                        if (Collects.isEmpty(this.parameters)) {
                            this.parameters = new LinkedList();
                        }
                        this.parameters.add(criterion.getValue());
                        sb.append(" and ? ");
                        this.parameters.add(criterion.getSecondValue());
                    }
                    if (!criterion.singleValue) continue;
                    if (Collects.isEmpty(this.parameters)) {
                        this.parameters = new LinkedList();
                    }
                    this.parameters.add(criterion.getValue());
                }
                if (list.isEmpty()) continue;
                if (Collects.isNotEmpty(this.selectPropertys) && this.selectPropertys.toString().contains("(")) {
                    this.sqlBuilder.HAVING(sb.toString());
                    continue;
                }
                this.sqlBuilder.WHERE(sb.toString());
            }
        }
        if (Collects.isEmpty(this.groupByClause)) {
            this.groupByClause = new LinkedList();
        }
        if (Collects.isNotEmpty(this.groupByClause)) {
            for (Object e : this.groupByClause) {
                this.sqlBuilder = (SQL)this.sqlBuilder.GROUP_BY(this.checkProperty(e.toString()).getColumn());
            }
        }
        if (this.orderByClause != null && Collects.isNotEmpty(orderList = this.orderByClause.getOrders())) {
            for (Sorts.Order order : orderList) {
                this.sqlBuilder = (SQL)this.sqlBuilder.ORDER_BY(this.checkProperty(order.getProperty()).getColumn() + " " + (Object)((Object)order.getDirection()));
            }
        }
        return this.sqlBuilder;
    }

    protected <T> List<T> list() {
        if (Collects.isEmpty(this.parameters)) {
            this.parameters = new LinkedList();
        }
        if (this.jdbcBuilder != null) {
            FindByExampleExecutor executor = new FindByExampleExecutor(this.applyWhere(), this.persistentClass, this.entityClass, this.pageInfo, this.entityElement, this.excludePropertys, this.mappings, this.distinct, this.selectPropertys, this.parameters.toArray(), this::getJdbcBuilder, this.dialectName);
            List results = (List)executor.execute();
            executor = null;
            return results;
        }
        return null;
    }

    protected <T> T get() {
        List<T> results = this.list();
        return Collects.isNotEmpty(results) ? (T)results.get(0) : null;
    }

    protected long count() {
        if (Collects.isNotEmpty(this.selectPropertys)) {
            Assert.isTrue(!this.selectPropertys.toString().contains("("), "The current SQL statement contains the default count (1) aggregate function, and there must be no aggregate function.");
        }
        if (Collects.isEmpty(this.parameters)) {
            this.parameters = new LinkedList();
        }
        if (this.jdbcBuilder != null) {
            CountByExampleExecutor executor;
            if (this.sqlBuilder == null || "".equals(this.sqlBuilder.toString())) {
                this.bulidSelect();
                executor = new CountByExampleExecutor(this.applyWhere(), this::getJdbcBuilder, this.parameters.toArray());
            } else {
                executor = new CountByExampleExecutor(this.sqlBuilder, this::getJdbcBuilder, this.parameters.toArray());
            }
            long count = (Long)executor.execute();
            executor = null;
            return count;
        }
        return 0L;
    }

    protected <T> PageInfo<T> page() {
        List results = null;
        long total = 0L;
        if (this.offset == null && this.limit == null) {
            if (this.pageInfo == null) {
                this.pageInfo = new PageInfo();
            }
            results = this.list();
            total = this.count();
            return new PageInfoImpl<T>(results, total, this.pageInfo.getPageNum(), this.pageInfo.getPageSize());
        }
        if (Collects.isEmpty(this.parameters)) {
            this.parameters = new LinkedList();
        }
        if (this.jdbcBuilder != null) {
            FindByExampleExecutor executor = new FindByExampleExecutor(this.applyWhere(), this.persistentClass, this.entityClass, this.offset, this.limit, this.entityElement, this.excludePropertys, this.mappings, this.distinct, this.selectPropertys, this.parameters.toArray(), this::getJdbcBuilder, this.dialectName);
            results = (List)executor.execute();
        }
        total = this.count();
        if (this.pageInfo == null) {
            this.pageInfo = new PageInfo();
        }
        this.pageInfo.pageNum = (int)Math.ceil((this.offset + this.limit) / this.limit);
        this.pageInfo.pageSize = this.limit;
        return new PageInfoImpl(results, total, this.pageInfo.getPageNum(), this.pageInfo.pageSize);
    }

    protected int delete() {
        if (Collects.isEmpty(this.parameters)) {
            this.parameters = new LinkedList();
        }
        Assert.notEmpty(this.oredCriteria, "Criteria conditional objects cannot be empty!");
        DeleteByExampleExecutor executor = new DeleteByExampleExecutor(this::getJdbcBuilder, this.applyWhere(), this.parameters.toArray(), this.persistentClass);
        int result = (Integer)executor.execute();
        return result;
    }

    private void bulidSelect() {
        this.sqlBuilder.FROM(this.entityElement.getTable());
        for (FieldElement fieldElement : this.entityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField()) continue;
            if (this.distinct) {
                this.sqlBuilder.SELECT_DISTINCT(fieldElement.getColumn());
                continue;
            }
            this.sqlBuilder.SELECT(fieldElement.getColumn());
        }
    }

    protected void initEntityElement(Class<?> entityClass) {
        this.checkEntity(entityClass);
        this.entityElement = ElementResolver.resolve(this.persistentClass);
    }

    protected boolean isEntity(Class<?> persistentClass) {
        return null != persistentClass.getAnnotation(Entity.class);
    }

    protected void checkEntity(Class<?> persistentClass) {
        Assert.isTrue(this.isEntity(persistentClass), persistentClass + " \u5982\u679c\u662f\u5b9e\u4f53\u7c7b\u578b\u8bf7\u4f7f\u7528@Entity\u6ce8\u89e3\u8fdb\u884c\u6807\u8bc6");
    }

    protected FieldElement checkProperty(String fieldName) {
        ArrayList<String> nameList = new ArrayList<String>();
        FieldElement newfieldElement = new FieldElement();
        for (FieldElement fieldElement : this.entityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField()) continue;
            if (fieldElement.getName().equals(fieldName)) {
                newfieldElement.setColumn(fieldElement.getColumn());
                newfieldElement.setType(fieldElement.getType());
            }
            nameList.add(fieldElement.getName());
        }
        newfieldElement.setName(fieldName);
        if (nameList.contains(fieldName)) {
            return newfieldElement;
        }
        throw new EasyJdbcException("The current entity class does not contain the name  <" + fieldName + ">  Properties!");
    }

    protected void clear() {
        this.oredCriteria.clear();
        if (this.parameters != null) {
            this.parameters.clear();
        }
        if (this.groupByClause != null) {
            this.groupByClause.clear();
        }
        if (this.groupByClause != null) {
            this.groupByClause.clear();
        }
        this.distinct = false;
    }

    private JdbcBuilder getJdbcBuilder() {
        return this.jdbcBuilder;
    }

    public static class Criterion {
        protected String condition;
        protected Object value;
        protected Object secondValue;
        protected String andOr;
        protected boolean noValue;
        protected boolean singleValue;
        protected boolean betweenValue;
        protected boolean listValue;
        protected String typeHandler;

        protected Criterion(String condition) {
            this(condition, false);
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            this(condition, value, typeHandler, false);
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null, false);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            this(condition, value, secondValue, typeHandler, false);
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null, false);
        }

        protected Criterion(String condition, boolean isOr) {
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
            this.andOr = isOr ? "OR" : "AND";
        }

        protected Criterion(String condition, Object value, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            String string = this.andOr = isOr ? "OR" : "AND";
            if (value instanceof Collection) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value, boolean isOr) {
            this(condition, value, null, isOr);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
            this.andOr = isOr ? "OR" : "AND";
        }

        protected Criterion(String condition, Object value, Object secondValue, boolean isOr) {
            this(condition, value, secondValue, null, isOr);
        }

        public String getCondition() {
            return this.condition;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getSecondValue() {
            return this.secondValue;
        }

        public String getAndOr() {
            return this.andOr;
        }

        public void setAndOr(String andOr) {
            this.andOr = andOr;
        }

        public boolean isNoValue() {
            return this.noValue;
        }

        public boolean isSingleValue() {
            return this.singleValue;
        }

        public boolean isBetweenValue() {
            return this.betweenValue;
        }

        public boolean isListValue() {
            return this.listValue;
        }

        public String getTypeHandler() {
            return this.typeHandler;
        }
    }
}

