/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.entity;

import com.xphsc.easyjdbc.core.entity.AggregateType;
import com.xphsc.easyjdbc.core.lambda.LambdaFunction;
import com.xphsc.easyjdbc.core.lambda.Reflections;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Aggregation {
    private List<Aggregate> aggregates;

    public Aggregation(List<Aggregate> aggregates) {
        this.aggregates = aggregates;
    }

    public Aggregation(Aggregate ... aggregates) {
        this(Arrays.asList(aggregates));
    }

    public Aggregation(AggregateType aggregateType, String property, String asProperty) {
        Aggregate aggregate = new Aggregate(aggregateType, property, asProperty);
        this.aggregates = new ArrayList<Aggregate>();
        this.aggregates.add(aggregate);
    }

    public <T> Aggregation aggregation(AggregateType aggregateType, LambdaFunction<T, Object> property, String asProperty) {
        Aggregate aggregate = new Aggregate().aggregate(aggregateType, property, asProperty);
        this.aggregates = new ArrayList<Aggregate>();
        this.aggregates.add(aggregate);
        return this;
    }

    public <T, S> Aggregation aggregation(AggregateType aggregateType, LambdaFunction<T, Object> property, LambdaFunction<S, Object> asProperty) {
        Aggregate aggregate = new Aggregate().aggregate(aggregateType, property, asProperty);
        this.aggregates = new ArrayList<Aggregate>();
        this.aggregates.add(aggregate);
        return this;
    }

    public List<Aggregate> getAggregates() {
        return this.aggregates;
    }

    public static class Aggregate
    implements Serializable {
        private AggregateType aggregateType;
        private String property;
        private String asProperty;

        public Aggregate(AggregateType type, String property, String asProperty) {
            this.aggregateType = type;
            this.property = property;
            this.asProperty = asProperty;
        }

        public Aggregate(AggregateType type, String property) {
            this.aggregateType = type;
            this.property = property;
        }

        public Aggregate() {
        }

        public <T> Aggregate aggregate(AggregateType type, LambdaFunction<T, Object> property, String asProperty) {
            this.aggregateType = type;
            this.property = Reflections.fieldNameForLambdaFunction(property);
            this.asProperty = asProperty;
            return this;
        }

        public <T, S> Aggregate aggregate(AggregateType type, LambdaFunction<T, Object> property, LambdaFunction<S, Object> asProperty) {
            this.aggregateType = type;
            this.property = Reflections.fieldNameForLambdaFunction(property);
            this.asProperty = Reflections.fieldNameForLambdaFunction(asProperty);
            return this;
        }

        public AggregateType getAggregateType() {
            return this.aggregateType;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setAggregateType(AggregateType aggregateType) {
            this.aggregateType = aggregateType;
        }

        public String getAsProperty() {
            return this.asProperty;
        }

        public void setAsProperty(String asProperty) {
            this.asProperty = asProperty;
        }
    }
}

