/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.entity;

import com.xphsc.easyjdbc.core.exception.EasyJdbcException;
import com.xphsc.easyjdbc.core.lambda.LambdaFunction;
import com.xphsc.easyjdbc.core.lambda.Reflections;
import com.xphsc.easyjdbc.util.Collects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Sorts {
    private List<Order> orders;
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;

    public Sorts(List<Order> orders) {
        if (Collects.isEmpty(orders)) {
            throw new EasyJdbcException("You have to provide at least one sort property to sort by!");
        }
        this.orders = orders;
    }

    public Sorts(Order ... orders) {
        this(Arrays.asList(orders));
    }

    public Sorts(Direction direction, String property) {
        Order order = new Order(direction, property);
        this.orders = new ArrayList<Order>();
        this.orders.add(order);
    }

    public <S> Sorts sort(Direction direction, LambdaFunction<S, Object> property) {
        Order order = new Order(direction, Reflections.fieldNameForLambdaFunction(property));
        this.orders = new ArrayList<Order>();
        this.orders.add(order);
        return this;
    }

    public Sorts() {
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public static Direction getDefaultDirection() {
        return DEFAULT_DIRECTION;
    }

    public static class Order
    implements Serializable {
        private Direction direction;
        private String property;

        public Order(Direction direction, String property) {
            this.direction = direction;
            this.property = property;
        }

        public <S> Order order(Direction direction, LambdaFunction<S, Object> property) {
            this.direction = direction;
            this.property = Reflections.fieldNameForLambdaFunction(property);
            return this;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

