/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.factory;

import com.xphsc.easyjdbc.annotation.DaoScan;
import com.xphsc.easyjdbc.core.binding.DaoProxy;
import com.xphsc.easyjdbc.core.factory.EasyDaoClassPathMapperScanner;
import com.xphsc.easyjdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DaoScannerRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerRequestProxyHandler(registry);
        AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(DaoScan.class.getName()));
        Class annotationClass = annoAttrs.getClass("annotationClass");
        EasyDaoClassPathMapperScanner scanner = new EasyDaoClassPathMapperScanner(registry, annotationClass);
        Class generatorClass = annoAttrs.getClass("nameGenerator");
        if (!BeanNameGenerator.class.equals((Object)generatorClass)) {
            scanner.setBeanNameGenerator((BeanNameGenerator)BeanUtils.instantiateClass((Class)generatorClass));
        }
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String pkg : annoAttrs.getStringArray("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : annoAttrs.getStringArray("basePackages")) {
            if (!StringUtil.hasText(pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : annoAttrs.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    private void registerRequestProxyHandler(BeanDefinitionRegistry registry) {
        GenericBeanDefinition jdbcDaoProxyDefinition = new GenericBeanDefinition();
        jdbcDaoProxyDefinition.setBeanClass(DaoProxy.class);
        jdbcDaoProxyDefinition.setAutowireMode(0);
        registry.registerBeanDefinition("daoProxy", (BeanDefinition)jdbcDaoProxyDefinition);
    }
}

