/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.factory;

import com.xphsc.easyjdbc.annotation.Dao;
import com.xphsc.easyjdbc.core.factory.EasyDaoBeanFactory;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Repository;

public class EasyDaoClassPathMapperScanner
extends ClassPathBeanDefinitionScanner {
    public EasyDaoClassPathMapperScanner(BeanDefinitionRegistry registry, Class<? extends Annotation> annotation) {
        super(registry, false);
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
        if (!Dao.class.equals(annotation)) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Dao.class));
        }
        if (!Repository.class.equals(annotation)) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Repository.class));
        }
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = null;
        if (basePackages != null) {
            beanDefinitions = super.doScan(basePackages);
        }
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No Dao interface was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        }
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            definition.getPropertyValues().add("proxy", (Object)this.getRegistry().getBeanDefinition("daoProxy"));
            definition.getPropertyValues().add("daoInterface", (Object)definition.getBeanClassName());
            definition.setBeanClass(EasyDaoBeanFactory.class);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        if (beanDefinition.getMetadata() != null) {
            return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
        }
        return false;
    }
}

