/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.metadata;

import com.xphsc.easyjdbc.annotation.CreatedDate;
import com.xphsc.easyjdbc.annotation.ModifiedDate;
import com.xphsc.easyjdbc.core.metadata.DynamicEntityElement;
import com.xphsc.easyjdbc.core.metadata.DynamicFieldElement;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.metadata.resolver.ColumnResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.CreatedDateResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.GeneratedValueResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.IdResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.LobResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.ModifieDateResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.Resolver;
import com.xphsc.easyjdbc.core.metadata.resolver.TableResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.TransientResolver;
import com.xphsc.easyjdbc.core.metadata.resolver.VersionResolver;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Jdbcs;
import com.xphsc.easyjdbc.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;

public class ElementResolver {
    public static final Map<String, EntityElement> ENTITIES = new ConcurrentHashMap<String, EntityElement>();
    public static final Map<String, DynamicEntityElement> DYNAMIC_ENTITIES = new ConcurrentHashMap<String, DynamicEntityElement>();
    private static final Map<Class<?>, Resolver> RESOLVERS = new ConcurrentHashMap();

    public static EntityElement resolve(Class<?> persistentClass) {
        String persistentClassName = persistentClass.getName();
        if (ENTITIES.containsKey(persistentClassName)) {
            return ENTITIES.get(persistentClassName);
        }
        EntityElement entityElement = new EntityElement();
        entityElement.setPersistentClass(persistentClass);
        entityElement.setName(persistentClassName);
        for (Annotation annotation : persistentClass.getAnnotations()) {
            Resolver resolver = RESOLVERS.get(annotation.annotationType());
            if (null == resolver) continue;
            resolver.resolve(entityElement, annotation);
        }
        Set<Class<?>> mappedSuperclass = ElementResolver.getMappedSuperclass(persistentClass);
        Set<Field> fields = Jdbcs.getFields(persistentClass, mappedSuperclass);
        for (Field field : fields) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            String fieldName = field.getName();
            Method readMethod = Jdbcs.getReadMethod(persistentClass, mappedSuperclass, fieldName, new Class[0]);
            Method writeMethod = Jdbcs.getWriteMethod(persistentClass, mappedSuperclass, fieldName, field.getType());
            FieldElement fieldElement = new FieldElement();
            fieldElement.setEntityElement(entityElement);
            fieldElement.setField(field);
            fieldElement.setType(field.getType());
            fieldElement.setName(fieldName);
            fieldElement.setReadMethod(readMethod);
            fieldElement.setWriteMethod(writeMethod);
            Annotation[] annotations = field.getAnnotations();
            if ((null == annotations || annotations.length == 0) && null != readMethod) {
                annotations = readMethod.getAnnotations();
            }
            for (Annotation annotation : field.getAnnotations()) {
                Resolver resolver = RESOLVERS.get(annotation.annotationType());
                if (null == resolver) continue;
                resolver.resolve(fieldElement, annotation);
            }
            if (!fieldElement.isTransientField()) {
                Assert.notNull(readMethod, "\u5b9e\u4f53:" + persistentClassName + ", \u5b57\u6bb5\uff1a" + fieldName + " \u6ca1\u6709get\u65b9\u6cd5");
                Assert.notNull(writeMethod, "\u5b9e\u4f53:" + persistentClassName + ", \u5b57\u6bb5\uff1a" + fieldName + " \u6ca1\u6709set\u65b9\u6cd5");
            }
            if (StringUtil.isEmpty(fieldElement.getColumn())) {
                fieldElement.setColumn(Jdbcs.camelToUnderline(fieldName));
            }
            fieldElement.setEntityElement(null);
            fieldElement.setField(null);
            entityElement.addFieldElement(fieldElement.getColumn().toUpperCase(), fieldElement);
        }
        Assert.notNull(entityElement.getPrimaryKey(), "\u5b9e\u4f53\uff1a" + entityElement.getName() + ",\u5fc5\u987b\u8981\u6ce8\u89e3\u4e3b\u952e\u3002");
        entityElement.setPersistentClass(null);
        ENTITIES.put(persistentClassName, entityElement);
        return entityElement;
    }

    private static Set<Class<?>> getMappedSuperclass(Class<?> cls) {
        HashSet classes = new HashSet();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (null == superclass.getAnnotation(MappedSuperclass.class)) continue;
            Assert.isNull(superclass.getAnnotation(Table.class), "\u5b9e\u4f53\uff1a" + superclass.getName() + ",\u6ce8\u89e3\u9519\u8bef\u3002 MappedSuperclass\u3001Table\u4e24\u4e2a\u6ce8\u89e3\u4e0d\u80fd\u540c\u65f6\u7528\u5728\u4e00\u4e2a\u7c7b\u4e0a");
            classes.add(superclass);
        }
        return Collections.unmodifiableSet(classes);
    }

    public static DynamicEntityElement resolveDynamic(Class<?> dynamicEntityClass, Map<String, String> dynamicMappings) {
        boolean dynamicMappinged = false;
        if (null != dynamicMappings && !dynamicMappings.isEmpty()) {
            dynamicMappinged = true;
        }
        String dynamicEntityClassName = dynamicEntityClass.getName();
        if (!dynamicMappinged && DYNAMIC_ENTITIES.containsKey(dynamicEntityClassName)) {
            return DYNAMIC_ENTITIES.get(dynamicEntityClassName);
        }
        DynamicEntityElement dynamicEntityElement = new DynamicEntityElement();
        dynamicEntityElement.setName(dynamicEntityClassName);
        HashSet superclass = new HashSet();
        Set<Field> fields = Jdbcs.getFields(dynamicEntityClass, superclass);
        for (Field field : fields) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            String fieldName = field.getName();
            Method readMethod = Jdbcs.getReadMethod(dynamicEntityClass, superclass, fieldName, new Class[0]);
            Method writeMethod = Jdbcs.getWriteMethod(dynamicEntityClass, superclass, fieldName, field.getType());
            Assert.notNull(readMethod, "\u5b9e\u4f53:" + dynamicEntityClassName + ", \u5b57\u6bb5\uff1a" + fieldName + " \u6ca1\u6709get\u65b9\u6cd5");
            Assert.notNull(writeMethod, "\u5b9e\u4f53:" + dynamicEntityClassName + ", \u5b57\u6bb5\uff1a" + fieldName + " \u6ca1\u6709set\u65b9\u6cd5");
            DynamicFieldElement dynamicFieldElement = new DynamicFieldElement();
            dynamicFieldElement.setName(fieldName);
            dynamicFieldElement.setType(field.getType());
            dynamicFieldElement.setReadMethod(readMethod);
            dynamicFieldElement.setWriteMethod(writeMethod);
            String columnName = Jdbcs.camelToUnderline(fieldName);
            if (dynamicMappinged && StringUtil.isNotEmpty(dynamicMappings.get(fieldName))) {
                columnName = dynamicMappings.get(fieldName);
            }
            dynamicFieldElement.setColumn(columnName);
            dynamicEntityElement.addDynamicFieldElements(columnName.toUpperCase(), dynamicFieldElement);
        }
        if (!dynamicMappinged) {
            DYNAMIC_ENTITIES.put(dynamicEntityClassName, dynamicEntityElement);
        }
        return dynamicEntityElement;
    }

    static {
        RESOLVERS.put(Table.class, new TableResolver());
        RESOLVERS.put(Id.class, new IdResolver());
        RESOLVERS.put(GeneratedValue.class, new GeneratedValueResolver());
        RESOLVERS.put(Column.class, new ColumnResolver());
        RESOLVERS.put(Lob.class, new LobResolver());
        RESOLVERS.put(Transient.class, new TransientResolver());
        RESOLVERS.put(Version.class, new VersionResolver());
        RESOLVERS.put(CreatedDate.class, new CreatedDateResolver());
        RESOLVERS.put(ModifiedDate.class, new ModifieDateResolver());
    }
}

