/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.metadata.type;

import com.xphsc.easyjdbc.core.exception.EasyJdbcException;
import com.xphsc.easyjdbc.core.metadata.type.JdbcType;
import com.xphsc.easyjdbc.core.metadata.type.TypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.TypeReflect;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseTypeHandler<T>
extends TypeReflect<T>
implements TypeHandler<T> {
    @Override
    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                throw new EasyJdbcException("JDBC requires that the JdbcType must be specified for all nullable parameters.");
            }
            try {
                ps.setNull(i, jdbcType.TYPE);
            }
            catch (SQLException var7) {
                throw new EasyJdbcException("Error setting null for parameter #" + i + " with JdbcType " + (Object)((Object)jdbcType) + " . Try setting a different JdbcType for this parameter or a different jdbcTypeForNull configuration property. Cause: " + var7, var7);
            }
        }
        try {
            this.setNonNullParameter(ps, i, parameter, jdbcType);
        }
        catch (Exception var6) {
            throw new EasyJdbcException("Error setting non null for parameter #" + i + " with JdbcType " + (Object)((Object)jdbcType) + " . Try setting a different JdbcType for this parameter or a different configuration property. Cause: " + var6, var6);
        }
    }

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        try {
            return this.getNullableResult(rs, columnName);
        }
        catch (Exception var4) {
            throw new EasyJdbcException("Error attempting to get column '" + columnName + "' from result set.  Cause: " + var4, var4);
        }
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        try {
            return this.getNullableResult(rs, columnIndex);
        }
        catch (Exception var4) {
            throw new EasyJdbcException("Error attempting to get column #" + columnIndex + " from result set.  Cause: " + var4, var4);
        }
    }

    @Override
    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        try {
            return this.getNullableResult(cs, columnIndex);
        }
        catch (Exception var4) {
            throw new EasyJdbcException("Error attempting to get column #" + columnIndex + " from callable statement.  Cause: " + var4, var4);
        }
    }

    public abstract void setNonNullParameter(PreparedStatement var1, int var2, T var3, JdbcType var4) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, String var2) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, int var2) throws SQLException;

    public abstract T getNullableResult(CallableStatement var1, int var2) throws SQLException;
}

