/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.metadata.type;

import com.xphsc.easyjdbc.core.exception.EasyJdbcException;
import com.xphsc.easyjdbc.core.metadata.type.BaseTypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.InstantTypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.LocalDateTimeTypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.LocalDateTypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.LocalTimeTypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.OffsetDateTimeTypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.OffsetTimeTypeHandler;
import com.xphsc.easyjdbc.core.metadata.type.YearTypeHandler;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.util.HashMap;
import java.util.Map;

public final class TypeBinding {
    private static Map<Class<?>, Class<?>> typeAliasMap = new HashMap();
    private BaseTypeHandler delegate;
    private ThreadLocal<BaseTypeHandler> typeThreadLocal = new ThreadLocal();
    private static Map<Class<?>, Class<?>> equalTypeMap = new HashMap();
    private boolean autoDialect = true;

    public void initDelegateType(Class dialectName) {
        if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.getType(dialectName);
            } else {
                this.typeThreadLocal.set(this.getType(dialectName));
            }
        }
    }

    public static Class type(Class<?> dialectName) {
        for (Class<?> jdbcType : typeAliasMap.keySet()) {
            if (!dialectName.equals(jdbcType)) continue;
            return jdbcType;
        }
        return null;
    }

    public BaseTypeHandler getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.typeThreadLocal.get();
    }

    public void clearDelegate() {
        this.typeThreadLocal.remove();
    }

    private BaseTypeHandler initType(Class<?> dialectClass) {
        BaseTypeHandler jdbcType = null;
        try {
            Class sqlDialectClass = this.resloveDialectClass(dialectClass);
            if (BaseTypeHandler.class.isAssignableFrom(sqlDialectClass)) {
                jdbcType = (BaseTypeHandler)sqlDialectClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new EasyJdbcException("Initialization  [" + dialectClass + "]Error occurred:" + e.getMessage(), e);
        }
        return jdbcType;
    }

    private Class resloveDialectClass(Class<?> className) throws Exception {
        if (typeAliasMap.containsKey(className)) {
            return typeAliasMap.get(className);
        }
        return Class.forName(className.getName());
    }

    private BaseTypeHandler getType(Class<?> dialectName) {
        Class jdbcType = TypeBinding.type(dialectName);
        if (jdbcType == null) {
            throw new EasyJdbcException("Unable to automatically retrieve database type");
        }
        BaseTypeHandler type = this.initType(jdbcType);
        return type;
    }

    static {
        typeAliasMap.put(LocalDate.class, LocalDateTypeHandler.class);
        typeAliasMap.put(LocalDateTime.class, LocalDateTimeTypeHandler.class);
        typeAliasMap.put(LocalTime.class, LocalTimeTypeHandler.class);
        typeAliasMap.put(Instant.class, InstantTypeHandler.class);
        typeAliasMap.put(OffsetDateTime.class, OffsetDateTimeTypeHandler.class);
        typeAliasMap.put(OffsetTime.class, OffsetTimeTypeHandler.class);
        typeAliasMap.put(Year.class, YearTypeHandler.class);
    }
}

