/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.parser;

import com.xphsc.easyjdbc.core.SimpleJdbcDao;
import com.xphsc.easyjdbc.core.parser.DefaultSQLParser;
import com.xphsc.easyjdbc.core.parser.SQLSelectParser;
import com.xphsc.easyjdbc.page.PageInfo;
import com.xphsc.easyjdbc.page.PageInfoImpl;
import com.xphsc.easyjdbc.page.PageRowBounds;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Collects;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DefaultSQLSelectParser
implements SQLSelectParser {
    protected static PageInfo pageInfo;
    protected static Class<?> entityClass;

    @Override
    public Object select(String selectSql, SimpleJdbcDao simpleJdbcDao, Class<?> modelClass, Method method, Map<String, Object> paramsMap) {
        MethodReturnType methodReturnType = new MethodReturnType(method, modelClass);
        DefaultSQLParser sqlParser = new DefaultSQLParser();
        Object returnResult = null;
        if (methodReturnType.returnsList) {
            Object[] result = null;
            if (sqlParser.hasFieldPlaceHolder(selectSql).booleanValue() || sqlParser.hasOgnlPlaceHolder(selectSql).booleanValue() || sqlParser.hasObjectPlaceHolder(selectSql).booleanValue()) {
                if (sqlParser.hasFieldPlaceHolder(selectSql).booleanValue()) {
                    result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, false);
                }
                if (sqlParser.hasOgnlPlaceHolder(selectSql).booleanValue()) {
                    result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, true);
                }
                if (sqlParser.hasObjectPlaceHolder(selectSql).booleanValue()) {
                    result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, false);
                }
                if (Collects.isNotEmpty(paramsMap)) {
                    returnResult = methodReturnType.returnsMap ? simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().queryForList((String)result[0], (Object[])result[1]) : simpleJdbcDao.getEasyJdbcTemplate().find((String)result[0], modelClass, (Object[])result[1]);
                }
            } else {
                Object object = returnResult = methodReturnType.returnsMap ? simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().queryForList(selectSql, new Object[0]) : simpleJdbcDao.getEasyJdbcTemplate().find(selectSql, modelClass, null);
            }
            if (methodReturnType.returnsOptional) {
                return Optional.ofNullable(returnResult);
            }
            return returnResult;
        }
        if (methodReturnType.returnsPage) {
            Object[] result = null;
            if (sqlParser.hasFieldPlaceHolder(selectSql).booleanValue()) {
                result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, false);
            }
            if (sqlParser.hasOgnlPlaceHolder(selectSql).booleanValue()) {
                result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, true);
            }
            if (sqlParser.hasObjectPlaceHolder(selectSql).booleanValue()) {
                result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, false);
            }
            if (pageInfo == null) {
                pageInfo = new PageInfo();
            }
            boolean containsOffset = Collects.containsKey(paramsMap, "offset");
            boolean containsLimit = Collects.containsKey(paramsMap, "limit");
            if (!containsOffset && !containsLimit) {
                Assert.isTrue(Collects.containsKey(paramsMap, "pageNum"), "The parameter must have pageNum attribute");
                Assert.isTrue(Collects.containsKey(paramsMap, "pageSize"), "The parameter must have pageSize attribute");
                Integer pageNum = Collects.getInteger(paramsMap, "pageNum");
                Integer pageSize = Collects.getInteger(paramsMap, "pageSize");
                pageInfo.setPageNum(pageNum);
                pageInfo.setPageSize(pageSize);
            } else {
                Assert.isTrue(containsOffset, "Parameters must have offset attributes");
                Assert.isTrue(containsLimit, "The parameter must have a limit attribute");
                Integer offset = Collects.getInteger(paramsMap, "offset");
                Integer limit = Collects.getInteger(paramsMap, "limit");
                pageInfo.setOffset(offset);
                pageInfo.setPageSize(limit);
            }
            PageInfo<Map<String, Object>> resultPage = null;
            if (result == null) {
                Object[] sqlAndParams = new Object[]{selectSql, null};
                if (!(containsOffset || containsLimit || methodReturnType.returnsMap)) {
                    resultPage = simpleJdbcDao.getEasyJdbcTemplate().findByPage((String)sqlAndParams[0], modelClass, pageInfo, null);
                }
                if (containsOffset && containsLimit && !methodReturnType.returnsMap) {
                    resultPage = simpleJdbcDao.getEasyJdbcTemplate().findByPage((String)sqlAndParams[0], modelClass, pageInfo.getOffset(), pageInfo.getPageSize(), null);
                }
                returnResult = methodReturnType.returnsMap ? DefaultSQLSelectParser.selectByPageInfo(simpleJdbcDao, sqlAndParams, pageInfo, paramsMap) : resultPage;
            } else {
                if (!(containsOffset || containsLimit || methodReturnType.returnsMap)) {
                    resultPage = simpleJdbcDao.getEasyJdbcTemplate().findByPage((String)result[0], modelClass, pageInfo, (Object[])result[1]);
                }
                if (containsOffset && containsLimit && !methodReturnType.returnsMap) {
                    resultPage = simpleJdbcDao.getEasyJdbcTemplate().findByPage((String)result[0], modelClass, pageInfo.getOffset(), pageInfo.getPageSize(), (Object[])result[1]);
                }
                Object object = returnResult = methodReturnType.returnsMap ? DefaultSQLSelectParser.selectByPageInfo(simpleJdbcDao, result, pageInfo, paramsMap) : resultPage;
            }
            if (methodReturnType.returnsOptional) {
                return Optional.ofNullable(returnResult);
            }
            return returnResult;
        }
        Object[] result = null;
        if (sqlParser.hasFieldPlaceHolder(selectSql).booleanValue()) {
            result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, false);
        }
        if (sqlParser.hasOgnlPlaceHolder(selectSql).booleanValue()) {
            result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, true);
        }
        if (sqlParser.hasObjectPlaceHolder(selectSql).booleanValue()) {
            result = sqlParser.sqlPlaceHolder(selectSql, paramsMap, false);
        }
        Object[] sqlAndParams = new Object[]{selectSql, null};
        if (methodReturnType.returnsCountTypes) {
            returnResult = result == null ? DefaultSQLSelectParser.count(simpleJdbcDao, method.getReturnType(), sqlAndParams) : DefaultSQLSelectParser.count(simpleJdbcDao, method.getReturnType(), result);
        } else if (methodReturnType.returnsVoid) {
            simpleJdbcDao.getEasyJdbcTemplate().execute((String)sqlAndParams[0]);
        } else if (!methodReturnType.returnsVoid) {
            result = result == null ? sqlAndParams : result;
            Object object = returnResult = methodReturnType.returnsMap ? simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().queryForMap((String)result[0], (Object[])result[1]) : simpleJdbcDao.getEasyJdbcTemplate().get((String)result[0], modelClass, (Object[])result[1]);
        }
        if (methodReturnType.returnsOptional) {
            return Optional.ofNullable(returnResult);
        }
        return returnResult;
    }

    private static PageInfo<Map<String, Object>> selectByPageInfo(SimpleJdbcDao simpleJdbcDao, Object[] result, PageInfo pageInfo, Map<String, Object> paramsMap) {
        long total = 0L;
        List<Map<String, Object>> maps = null;
        String sql = "";
        if (!Collects.containsKey(paramsMap, "offset") && !Collects.containsKey(paramsMap, "limit")) {
            Assert.isTrue(pageInfo.getPageNum() >= 1, "PageNum must be greater than or equal to 1");
            Assert.isTrue(pageInfo.getPageSize() > 0, "PageSize must be greater than 0");
            sql = PageRowBounds.pagination(simpleJdbcDao.getEasyJdbcTemplate().getDialectName(), (String)result[0], (pageInfo.getPageNum() - 1) * pageInfo.getPageSize(), pageInfo.getPageSize());
        } else {
            Integer offset = Collects.getInteger(paramsMap, "offset");
            Integer limit = Collects.getInteger(paramsMap, "limit");
            sql = PageRowBounds.pagination(simpleJdbcDao.getEasyJdbcTemplate().getDialectName(), (String)result[0], offset, limit);
        }
        if (result[1] == null) {
            total = simpleJdbcDao.getEasyJdbcTemplate().count((String)result[0], new Object[0]);
            maps = simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().queryForList(sql, new Object[0]);
        } else {
            total = simpleJdbcDao.getEasyJdbcTemplate().count((String)result[0], (Object[])result[1]);
            maps = simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().queryForList(sql, (Object[])result[1]);
        }
        return new PageInfoImpl<Map<String, Object>>(maps, total, pageInfo.getPageNum(), pageInfo.getPageSize());
    }

    private static Object count(SimpleJdbcDao simpleJdbcDao, Class<?> returnType, Object[] result) {
        Long count = simpleJdbcDao.getEasyJdbcTemplate().count((String)result[0], (Object[])result[1]);
        Integer IntegerResult = returnType.isAssignableFrom(Integer.TYPE) || returnType.isAssignableFrom(Integer.class) ? Integer.valueOf(((Object)count).toString()) : null;
        Long longResult = returnType.isAssignableFrom(Long.TYPE) || returnType.isAssignableFrom(Long.class) ? Long.valueOf(((Object)count).toString()) : null;
        return IntegerResult == null ? (Number)longResult : (Number)IntegerResult;
    }

    public static class MethodReturnType {
        private boolean returnsCountTypes;
        private boolean returnsMap;
        private boolean returnsPage;
        private boolean returnsList;
        private boolean returnsVoid;
        private boolean returnsOptional;
        private static Set<Class<? extends Object>> returnCountTypes = new HashSet<Class<? extends Object>>();

        public MethodReturnType(Method method, Class<?> modelClass) {
            Class<Object> returnType = method.getReturnType();
            Type type = method.getGenericReturnType();
            if (this.getReturnCountTypes(method) != null) {
                this.returnsCountTypes = true;
            }
            if (returnType.isAssignableFrom(Map.class)) {
                this.returnsMap = true;
            }
            if (returnType.isAssignableFrom(PageInfo.class)) {
                this.returnsPage = true;
            }
            if (returnType.isAssignableFrom(List.class)) {
                this.returnsList = true;
            }
            if (returnType.isAssignableFrom(Void.TYPE)) {
                this.returnsVoid = true;
            }
            this.returnsOptional = Optional.class.equals(returnType);
            if (type instanceof ParameterizedType) {
                String EQURE_MAP = "Map";
                if (this.returnsOptional) {
                    if ((type = ((ParameterizedType)type).getActualTypeArguments()[0]).equals(Map.class) || type.equals(Number.class) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Long.class) || type.equals(modelClass)) {
                        entityClass = (Class)type;
                    } else {
                        this.returnsList = ((ParameterizedType)type).getRawType().equals(List.class);
                        this.returnsPage = ((ParameterizedType)type).getRawType().equals(PageInfo.class);
                        entityClass = ((ParameterizedType)type).getActualTypeArguments()[0].getTypeName().contains("Map") ? Map.class : (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                    }
                } else {
                    entityClass = ((ParameterizedType)type).getActualTypeArguments()[0].getTypeName().contains("Map") ? Map.class : (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                }
            }
            if (entityClass != null) {
                if (entityClass.isAssignableFrom(Map.class)) {
                    this.returnsMap = true;
                }
                if (entityClass.isAssignableFrom(Number.class) || entityClass.isAssignableFrom(Integer.class) || entityClass.isAssignableFrom(Integer.TYPE) || entityClass.isAssignableFrom(Long.TYPE) || entityClass.isAssignableFrom(Long.class)) {
                    this.returnsCountTypes = true;
                }
            }
            if (modelClass != null && modelClass.isAssignableFrom(Map.class)) {
                this.returnsMap = true;
            }
        }

        private Class<? extends Object> getReturnCountTypes(Method method) {
            return this.chooseReturnType(method, returnCountTypes);
        }

        private Class<? extends Object> chooseReturnType(Method method, Set<Class<? extends Object>> types) {
            for (Class<? extends Object> type : types) {
                if (!type.equals(method.getReturnType())) continue;
                return type;
            }
            return null;
        }

        static {
            returnCountTypes.add(Number.class);
            returnCountTypes.add(Integer.class);
            returnCountTypes.add(Integer.TYPE);
            returnCountTypes.add(Long.TYPE);
            returnCountTypes.add(Long.class);
        }
    }
}

