/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.processor;

import com.xphsc.easyjdbc.annotation.SqlDelete;
import com.xphsc.easyjdbc.annotation.SqlDeleteProvider;
import com.xphsc.easyjdbc.annotation.SqlInsert;
import com.xphsc.easyjdbc.annotation.SqlInsertProvider;
import com.xphsc.easyjdbc.annotation.SqlOptions;
import com.xphsc.easyjdbc.annotation.SqlSelect;
import com.xphsc.easyjdbc.annotation.SqlSelectProvider;
import com.xphsc.easyjdbc.annotation.SqlUpdate;
import com.xphsc.easyjdbc.annotation.SqlUpdateProvider;
import com.xphsc.easyjdbc.core.exception.EasyJdbcException;
import com.xphsc.easyjdbc.core.metadata.SQLOptionType;
import com.xphsc.easyjdbc.core.parser.DefaultSQLOptionTypeParser;
import com.xphsc.easyjdbc.core.parser.DefaultSQLParser;
import com.xphsc.easyjdbc.core.parser.DefaultSQLSelectParser;
import com.xphsc.easyjdbc.core.processor.AbstractDaoMethodProcessor;
import com.xphsc.easyjdbc.util.Collects;
import com.xphsc.easyjdbc.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class AnnotationMethodProcessor
extends AbstractDaoMethodProcessor {
    private Method providerMethod;
    private Class<?> providerType;
    private String sql = "";
    private String providerMethodName = null;
    private boolean useGeneratedKeys = false;
    private String keyProperty = null;
    private boolean hasInsertOrUpdatePlaceHolder = false;

    @Override
    public Object process() {
        Object[] result = null;
        this.getAnnotationType();
        DefaultSQLOptionTypeParser sqlOptionTypeParser = new DefaultSQLOptionTypeParser();
        SQLOptionType sqlOptionType = sqlOptionTypeParser.getSqlCommandType(this.method);
        if (this.providerType != null) {
            for (Method m : this.providerType.getMethods()) {
                if (!this.providerMethodName.equals(m.getName()) || m.getReturnType() != String.class) continue;
                if (this.providerMethod != null) {
                    throw new EasyJdbcException("Error creating Sql for SqlProvider. Method '" + this.providerMethodName + "' is found multiple in SqlProvider '" + this.providerType.getName() + "'. Sql provider method can not overload.");
                }
                this.providerMethod = m;
            }
            Map params = null;
            try {
                if (!Collects.isEmpty(this.providerMethod.getParameterTypes())) {
                    Class<Map> parameterType = this.providerMethod.getParameterTypes()[0];
                    if (parameterType.isAssignableFrom(Map.class)) {
                        params = this.paramsMap;
                        this.sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), params);
                    }
                } else {
                    this.sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (sqlOptionType.equals((Object)SQLOptionType.SQLSELECT)) {
            DefaultSQLSelectParser sqlSelectParser = new DefaultSQLSelectParser();
            return sqlSelectParser.select(this.sql, this.simpleJdbcDao, this.persistentClass, this.method, this.paramsMap);
        }
        DefaultSQLParser sqlParser = new DefaultSQLParser();
        result = this.hasInsertOrUpdatePlaceHolder ? sqlParser.sqlPlaceHolder(this.sql, this.paramsMap, false) : (sqlParser.hasOgnlPlaceHolder(this.sql) != false ? sqlParser.sqlPlaceHolder(this.sql, this.paramsMap, true) : sqlParser.sqlPlaceHolder(this.sql, null, true));
        Object returnResult = null;
        Class<?> returnType = this.method.getReturnType();
        boolean returnsOptional = Optional.class.equals(returnType);
        if (sqlOptionType.equals((Object)SQLOptionType.SQLUPDATE)) {
            if (this.hasInsertOrUpdatePlaceHolder) {
                String sql = (String)result[0];
                returnResult = Collects.isNotEmpty(this.paramsMap) ? this.simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().update((String)result[0], (Object[])result[1]) : this.simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().update(sql, new Object[0]);
            }
            if (returnsOptional) {
                return Optional.ofNullable(returnResult);
            }
            return returnResult instanceof int[] ? Integer.valueOf(((int[])returnResult).length) : returnResult;
        }
        if (sqlOptionType.equals((Object)SQLOptionType.SQLINSERT) || sqlOptionType.equals((Object)SQLOptionType.SQLDELETE)) {
            if (this.useGeneratedKeys) {
                GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
                final String finalKeyProperty = this.keyProperty;
                final Object[] finalResult = result;
                final Object[] finalResult1 = result;
                this.simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().update(new PreparedStatementCreator(){

                    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                        PreparedStatement ps = con.prepareStatement((String)finalResult[0], new String[]{finalKeyProperty});
                        int i = 1;
                        for (Object object : (Object[])finalResult1[1]) {
                            ps.setObject(i, object);
                            ++i;
                        }
                        return ps;
                    }
                }, (KeyHolder)keyHolder);
                Object key = null;
                returnResult = this.getKey(key, this.method, (KeyHolder)keyHolder);
            } else if (this.hasInsertOrUpdatePlaceHolder) {
                returnResult = this.simpleJdbcDao.getEasyJdbcTemplate().getJdbcBuilder().update((String)result[0], (Object[])result[1]);
            }
        }
        if (returnsOptional) {
            return Optional.ofNullable(returnResult);
        }
        return returnResult;
    }

    private Object getKey(Object key, Method method, KeyHolder keyHolder) {
        ReturnKeyType returnKeyType = new ReturnKeyType(method);
        if (returnKeyType.returnsInteger) {
            key = keyHolder.getKey().intValue();
        }
        if (returnKeyType.returnsLong) {
            key = keyHolder.getKey().longValue();
        }
        if (returnKeyType.returnsShort) {
            key = keyHolder.getKey().shortValue();
        }
        if (returnKeyType.returnsDouble) {
            key = keyHolder.getKey().doubleValue();
        }
        if (returnKeyType.returnsByte) {
            key = keyHolder.getKey().byteValue();
        }
        if (returnKeyType.returnsObject) {
            key = keyHolder.getKey();
        }
        return key;
    }

    private void getAnnotationType() {
        Annotation[] annotations;
        if (this.annotation instanceof SqlInsert) {
            this.hasInsertOrUpdatePlaceHolder = true;
            SqlInsert sqlInsert = (SqlInsert)this.annotation;
            this.sql = sqlInsert.value();
        }
        for (Annotation annotation : annotations = this.method.getAnnotations()) {
            if (!annotation.annotationType().equals(SqlOptions.class)) continue;
            SqlOptions sqlOptions = (SqlOptions)annotation;
            this.useGeneratedKeys = sqlOptions.useGeneratedKeys();
            this.keyProperty = StringUtil.isNotBlank(sqlOptions.keyProperty()) ? sqlOptions.keyProperty() : "id";
        }
        if (this.annotation instanceof SqlUpdate) {
            this.hasInsertOrUpdatePlaceHolder = true;
            SqlUpdate sqlUpdate = (SqlUpdate)this.annotation;
            this.sql = sqlUpdate.value();
        }
        if (this.annotation instanceof SqlDelete) {
            SqlDelete sqlDelete = (SqlDelete)this.annotation;
            this.sql = sqlDelete.value();
        }
        if (this.annotation instanceof SqlUpdateProvider) {
            SqlUpdateProvider sqlUpdateProvider = (SqlUpdateProvider)this.annotation;
            this.providerType = sqlUpdateProvider.type();
            this.providerMethodName = sqlUpdateProvider.method();
            if (sqlUpdateProvider.returnType() != null) {
                this.persistentClass = sqlUpdateProvider.returnType();
            }
        }
        if (this.annotation instanceof SqlInsertProvider) {
            SqlInsertProvider sqlInsertProvider = (SqlInsertProvider)this.annotation;
            this.providerType = sqlInsertProvider.type();
            this.providerMethodName = sqlInsertProvider.method();
            if (sqlInsertProvider.returnType() != null) {
                this.persistentClass = sqlInsertProvider.returnType();
            }
        }
        if (this.annotation instanceof SqlDeleteProvider) {
            SqlDeleteProvider sqlDeleteProvider = (SqlDeleteProvider)this.annotation;
            this.providerType = sqlDeleteProvider.type();
            this.providerMethodName = sqlDeleteProvider.method();
            if (sqlDeleteProvider.returnType() != null) {
                this.persistentClass = sqlDeleteProvider.returnType();
            }
        }
        if (this.annotation instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)this.annotation;
            this.sql = sqlSelect.value();
            if (sqlSelect.entityClass() != null && sqlSelect.entityClass() != Void.TYPE) {
                this.persistentClass = sqlSelect.entityClass();
            }
        }
        if (this.annotation instanceof SqlSelectProvider) {
            SqlSelectProvider sqlSelectProvider = (SqlSelectProvider)this.annotation;
            this.providerType = sqlSelectProvider.type();
            this.providerMethodName = sqlSelectProvider.method();
            if (sqlSelectProvider.entityClass() != null && sqlSelectProvider.entityClass() != Void.TYPE) {
                this.persistentClass = sqlSelectProvider.entityClass();
            }
        }
    }

    public static class ReturnKeyType {
        private boolean returnsInteger;
        private boolean returnsLong;
        private boolean returnsShort;
        private boolean returnsDouble;
        private boolean returnsByte;
        private boolean returnsObject;

        public ReturnKeyType(Method method) {
            Class<Object> returnType = method.getReturnType();
            if (returnType.isAssignableFrom(Integer.class) || returnType.isAssignableFrom(Integer.TYPE)) {
                this.returnsInteger = true;
            }
            if (returnType.isAssignableFrom(Long.class) || returnType.isAssignableFrom(Long.TYPE)) {
                this.returnsLong = true;
            }
            if (returnType.isAssignableFrom(Short.TYPE) || returnType.isAssignableFrom(Short.class)) {
                this.returnsShort = true;
            }
            if (returnType.isAssignableFrom(Double.TYPE) || returnType.isAssignableFrom(Double.class)) {
                this.returnsDouble = true;
            }
            if (returnType.isAssignableFrom(Byte.TYPE) || returnType.isAssignableFrom(Byte.class)) {
                this.returnsByte = true;
            }
            if (returnType.isAssignableFrom(Object.class)) {
                this.returnsObject = true;
            }
        }
    }
}

