/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.support;

import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.lambda.Reflections;
import com.xphsc.easyjdbc.core.support.JdbcBuilder;
import com.xphsc.easyjdbc.page.PageInfo;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public abstract class EasyJdbcAccessor
implements InitializingBean {
    private DataSource dataSource;
    private SQLExceptionTranslator exceptionTranslator;
    private boolean lazyInit = true;
    private String dialectName;
    private JdbcTemplate jdbcTemplate;
    private boolean useLocalCache;
    private boolean showSQL;
    private String interfaceClass;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        if (this.jdbcTemplate != null) {
            this.jdbcTemplate = new JdbcTemplate(dataSource);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDatabaseProductName(String dbName) {
        this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(dbName);
    }

    protected void setExceptionTranslator(SQLExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    protected synchronized SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            DataSource dataSource = this.getDataSource();
            this.exceptionTranslator = dataSource != null ? new SQLErrorCodeSQLExceptionTranslator(dataSource) : new SQLStateSQLExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    protected void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    protected boolean isLazyInit() {
        return this.lazyInit;
    }

    public void afterPropertiesSet() {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("Property 'dataSource' is required");
        }
        if (!this.isLazyInit()) {
            this.getExceptionTranslator();
        }
    }

    public String getDialectName() {
        return this.dialectName;
    }

    public void setDialectName(String dialectName) {
        this.dialectName = dialectName;
    }

    protected void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        if (jdbcTemplate.getDataSource() != null) {
            this.dataSource = jdbcTemplate.getDataSource();
        }
    }

    protected <T> void setJdbcTemplate(LambdaSupplier<T> jdbcTemplate) {
        this.jdbcTemplate = (JdbcTemplate)Reflections.classForLambdaSupplier(jdbcTemplate);
        if (this.jdbcTemplate.getDataSource() != null) {
            this.dataSource = this.jdbcTemplate.getDataSource();
        }
    }

    public JdbcBuilder getJdbcBuilder() {
        JdbcBuilder jdbcBuilder = new JdbcBuilder(this::getJdbcTemplate, this::isUseLocalCache, this::isShowSQL, this::getInterfaceClass);
        return jdbcBuilder;
    }

    protected PageInfo pageInfo(PageInfo page) {
        int pageSize;
        int pageNum;
        PageInfo pageInfo = new PageInfo();
        if (page.getOffset() == -1 && page.getPageNum() >= 1) {
            pageNum = page.getPageNum();
            pageSize = page.getPageSize();
        } else {
            pageNum = (int)Math.ceil((page.getOffset() + page.getLimit()) / page.getLimit());
            pageSize = page.getLimit();
        }
        pageInfo.setPageNum(pageNum);
        pageInfo.setPageSize(pageSize);
        return pageInfo;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public boolean showSQL(boolean showSQL) {
        this.showSQL = showSQL;
        return this.showSQL;
    }

    public boolean useLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
        return this.useLocalCache;
    }

    public void interfaceClass(String interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    private boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    private boolean isShowSQL() {
        return this.showSQL;
    }

    private String getInterfaceClass() {
        this.interfaceClass = this.interfaceClass != null ? this.interfaceClass : "easyJdbcTemplate";
        return this.interfaceClass;
    }
}

