/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.transform;

import com.xphsc.easyjdbc.core.metadata.DynamicEntityElement;
import com.xphsc.easyjdbc.core.metadata.DynamicFieldElement;
import com.xphsc.easyjdbc.core.metadata.resultset.DefaultResultSet;
import com.xphsc.easyjdbc.util.Jdbcs;
import com.xphsc.easyjdbc.util.StringUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.LobHandler;

public class DynamicEntityRowMapper<T>
implements RowMapper<T> {
    private final LobHandler lobHandler;
    private final DynamicEntityElement dynamicEntityElement;
    private final Class<?> dynamicEntityClass;
    private final boolean isMap;

    public DynamicEntityRowMapper(LobHandler lobHandler, DynamicEntityElement dynamicEntityElement, Class<?> dynamicEntityClass) {
        this.lobHandler = lobHandler;
        this.dynamicEntityElement = dynamicEntityElement;
        this.dynamicEntityClass = dynamicEntityClass;
        this.isMap = true;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object instance = Jdbcs.newInstance(this.dynamicEntityClass);
        ResultSetMetaData rsm = rs.getMetaData();
        int col = rsm.getColumnCount();
        for (int i = 1; i <= col; ++i) {
            Object value;
            String columnLabel = StringUtil.toUnderScoreCase(rsm.getColumnLabel(i));
            int columnType = rsm.getColumnType(i);
            DynamicFieldElement dynamicFieldElement = this.dynamicEntityElement.getDynamicFieldElements().get(columnLabel.toUpperCase());
            if (null == dynamicFieldElement || (value = DefaultResultSet.getResultValue(rs, i, columnType, dynamicFieldElement.getType())) == null) continue;
            String errorMsg = "\u5b9e\u4f53\uff1a" + this.dynamicEntityElement.getName() + " \u5b57\u6bb5\uff1a" + dynamicFieldElement.getName() + " \u8bbe\u7f6e\u503c\u5931\u8d25";
            Jdbcs.invokeMethod(instance, dynamicFieldElement.getWriteMethod(), errorMsg, value);
        }
        return instance;
    }
}

