/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.transform;

import com.xphsc.easyjdbc.core.exception.EasyJdbcException;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.metadata.resultset.DefaultResultSet;
import com.xphsc.easyjdbc.util.Jdbcs;
import com.xphsc.easyjdbc.util.StringUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.LobHandler;

public class EntityRowMapper<T>
implements RowMapper<T> {
    private final LobHandler lobHandler;
    private final EntityElement entityElement;
    private final Class<?> persistentClass;

    public EntityRowMapper(LobHandler lobHandler, EntityElement entityElement, Class<?> persistentClass) {
        this.persistentClass = persistentClass;
        this.entityElement = entityElement;
        this.lobHandler = lobHandler;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object instance = Jdbcs.newInstance(this.persistentClass);
        ResultSetMetaData rsm = rs.getMetaData();
        int col = rsm.getColumnCount();
        for (int i = 1; i <= col; ++i) {
            String columnLabel = StringUtil.toUnderScoreCase(rsm.getColumnLabel(i));
            int columnType = rsm.getColumnType(i);
            FieldElement fieldElement = this.entityElement.getFieldElements().get(columnLabel.toUpperCase());
            if (null == fieldElement) continue;
            Object value = null;
            value = fieldElement.isClob() ? this.lobHandler.getClobAsString(rs, i) : (fieldElement.isBlob() ? (Object)this.lobHandler.getBlobAsBytes(rs, i) : DefaultResultSet.getResultValue(rs, i, columnType, fieldElement.getType()));
            if (value == null) continue;
            if (null == fieldElement.getWriteMethod()) {
                throw new EasyJdbcException("\u5b9e\u4f53\uff1a" + this.entityElement.getName() + " \u5b57\u6bb5\uff1a" + fieldElement.getName() + " \u6ca1\u6709set\u65b9\u6cd5");
            }
            String errorMsg = "\u5b9e\u4f53\uff1a" + this.entityElement.getName() + " \u5b57\u6bb5\uff1a" + fieldElement.getName() + " \u8bbe\u7f6e\u503c\u5931\u8d25";
            Jdbcs.invokeMethod(instance, fieldElement.getWriteMethod(), errorMsg, value);
        }
        return instance;
    }
}

