/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.transform.setter;

import com.xphsc.easyjdbc.core.metadata.ValueElement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.support.lob.LobHandler;

public class ValueBatchSetter
implements BatchPreparedStatementSetter {
    private final LobHandler lobHandler;
    private final List<LinkedList<ValueElement>> batchValueElements;

    public ValueBatchSetter(LobHandler lobHandler, List<LinkedList<ValueElement>> batchValueElements) {
        this.lobHandler = lobHandler;
        this.batchValueElements = batchValueElements;
    }

    public void setValues(PreparedStatement ps, int i) throws SQLException {
        List valueElements = this.batchValueElements.get(i);
        for (int j = 0; j < valueElements.size(); ++j) {
            int paramIndex = j + 1;
            ValueElement param = (ValueElement)valueElements.get(j);
            if (param.isClob()) {
                if (null != param.getValue()) {
                    this.lobHandler.getLobCreator().setClobAsString(ps, paramIndex, (String)param.getValue());
                    continue;
                }
                ps.setObject(paramIndex, null);
                continue;
            }
            if (param.isBlob()) {
                if (null != param.getValue()) {
                    this.lobHandler.getLobCreator().setBlobAsBytes(ps, paramIndex, (byte[])param.getValue());
                    continue;
                }
                ps.setObject(paramIndex, null);
                continue;
            }
            ps.setObject(paramIndex, param.getValue());
        }
    }

    public int getBatchSize() {
        return this.batchValueElements.size();
    }
}

