/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.core.transform.setter;

import com.xphsc.easyjdbc.core.metadata.ValueElement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.support.lob.LobHandler;

public class ValueSetter
implements PreparedStatementSetter {
    private final LobHandler lobHandler;
    private final List<ValueElement> valueElements;

    public ValueSetter(LobHandler lobHandler, List<ValueElement> valueElements) {
        this.lobHandler = lobHandler;
        this.valueElements = valueElements;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        for (int i = 0; i < this.valueElements.size(); ++i) {
            int paramIndex = i + 1;
            ValueElement param = this.valueElements.get(i);
            if (param.isClob()) {
                if (null != param.getValue()) {
                    this.lobHandler.getLobCreator().setClobAsString(ps, paramIndex, (String)param.getValue());
                    continue;
                }
                ps.setObject(paramIndex, null);
                continue;
            }
            if (param.isBlob()) {
                if (null != param.getValue()) {
                    this.lobHandler.getLobCreator().setBlobAsBytes(ps, paramIndex, (byte[])param.getValue());
                    continue;
                }
                ps.setObject(paramIndex, null);
                continue;
            }
            ps.setObject(paramIndex, param.getValue());
        }
    }
}

