/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor;

import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.lambda.Reflections;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.metadata.id.SnowFlakeId;
import com.xphsc.easyjdbc.core.support.JdbcBuilder;
import com.xphsc.easyjdbc.executor.Executor;
import com.xphsc.easyjdbc.util.Assert;
import com.xphsc.easyjdbc.util.Jdbcs;
import java.util.UUID;
import javax.persistence.Entity;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;

public abstract class AbstractExecutor<T>
implements Executor<T> {
    protected static final LobHandler LOBHANDLER = new DefaultLobHandler();
    protected final JdbcBuilder jdbcBuilder;

    public <S> AbstractExecutor(LambdaSupplier<S> jdbcBuilder) {
        this.jdbcBuilder = (JdbcBuilder)Reflections.classForLambdaSupplier(jdbcBuilder);
    }

    @Override
    public T execute() throws JdbcDataException {
        this.prepare();
        return this.doExecute();
    }

    protected abstract void prepare();

    protected abstract T doExecute() throws JdbcDataException;

    protected Object generatedId(Object persistent, FieldElement fieldElement, Object value) {
        Object id = null;
        if ((null == value || "".equals(value) || value.equals(0) || value.equals(0L)) && fieldElement.isGeneratedValue()) {
            if ("uuid".equals(fieldElement.getGenerator())) {
                id = UUID.randomUUID().toString().replaceAll("-", "");
                String errorMsg = "entity\uff1a" + persistent.getClass().getName() + " Primary key\uff1a" + fieldElement.getName() + " Setting value failed";
                Jdbcs.invokeMethod(persistent, fieldElement.getWriteMethod(), errorMsg, id);
            } else if ("SNOWFLAKEID".equals(fieldElement.getGenerator())) {
                SnowFlakeId snowFlake = new SnowFlakeId(2L, 3L);
                String errorMsg = "entity\uff1a" + persistent.getClass().getName() + " Primary key\uff1a" + fieldElement.getName() + " Setting value failed";
                if ("java.lang.Integer".equals(fieldElement.getType().getName())) {
                    Integer entityId = new Long(snowFlake.nextId()).intValue();
                    id = entityId;
                } else if ("int".equals(fieldElement.getType().getName())) {
                    int entityId = new Long(snowFlake.nextId()).intValue();
                    id = entityId;
                } else if ("java.lang.String".equals(fieldElement.getType().getName())) {
                    String entityId = new Long(snowFlake.nextId()).toString();
                    id = entityId;
                } else {
                    id = snowFlake.nextId();
                }
                Jdbcs.invokeMethod(persistent, fieldElement.getWriteMethod(), errorMsg, id);
            }
            return id;
        }
        return value;
    }

    protected boolean isEntity(Class<?> persistentClass) {
        return null != persistentClass.getAnnotation(Entity.class);
    }

    protected void checkEntity(Class<?> persistentClass) {
        Assert.isTrue(this.isEntity(persistentClass), persistentClass + " If it is an entity type, use the @Entity annotation for identification");
    }
}

