/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor;

import com.xphsc.easyjdbc.builder.SQL;
import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.core.metadata.ElementResolver;
import com.xphsc.easyjdbc.core.metadata.EntityElement;
import com.xphsc.easyjdbc.core.metadata.FieldElement;
import com.xphsc.easyjdbc.core.metadata.ValueElement;
import com.xphsc.easyjdbc.core.transform.setter.ValueBatchSetter;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import com.xphsc.easyjdbc.util.Jdbcs;
import java.util.LinkedList;
import java.util.List;

public class BatchInsertExecutor
extends AbstractExecutor<int[]> {
    private final LinkedList persistents = new LinkedList();
    private final SQL sqlBuilder = SQL.BUILD();
    private List<LinkedList<ValueElement>> batchValueElements;

    public <S> BatchInsertExecutor(LambdaSupplier<S> jdbcBuilder, List<?> persistents) {
        super(jdbcBuilder);
        this.persistents.addAll(persistents);
    }

    @Override
    public void prepare() {
        Class<?> persistentClass = this.persistents.get(0).getClass();
        this.checkEntity(persistentClass);
        EntityElement entityElement = ElementResolver.resolve(persistentClass);
        this.batchValueElements = new LinkedList<LinkedList<ValueElement>>();
        this.sqlBuilder.INSERT_INTO(entityElement.getTable());
        for (FieldElement fieldElement : entityElement.getFieldElements().values()) {
            if (fieldElement.isTransientField()) continue;
            this.sqlBuilder.VALUES(fieldElement.getColumn(), "?");
        }
        for (FieldElement persistent : this.persistents) {
            LinkedList<ValueElement> valueElements = new LinkedList<ValueElement>();
            for (FieldElement fieldElement : entityElement.getFieldElements().values()) {
                if (fieldElement.isTransientField()) continue;
                Object value = Jdbcs.invokeMethod(persistent, fieldElement.getReadMethod(), "entity\uff1a" + entityElement.getName() + " field\uff1a" + fieldElement.getName() + " Failure to obtain value", new Object[0]);
                if (fieldElement.isPrimaryKey()) {
                    value = super.generatedId(persistent, fieldElement, value);
                }
                valueElements.add(new ValueElement(value, fieldElement.isClob(), fieldElement.isBlob()));
            }
            this.batchValueElements.add(valueElements);
        }
    }

    @Override
    protected int[] doExecute() throws JdbcDataException {
        String sql = this.sqlBuilder.toString();
        return this.jdbcBuilder.batchUpdate(sql, new ValueBatchSetter(LOBHANDLER, this.batchValueElements));
    }
}

