/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.executor;

import com.xphsc.easyjdbc.core.exception.JdbcDataException;
import com.xphsc.easyjdbc.core.lambda.LambdaSupplier;
import com.xphsc.easyjdbc.executor.AbstractExecutor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class ExecProcExecutor<E>
extends AbstractExecutor<E> {
    private final Class<?> persistentClass;
    private final String sql;
    private final Object[] parameters;
    private Map<Integer, Integer> outParameters;

    public <S> ExecProcExecutor(LambdaSupplier<S> jdbcBuilder, String sql, Class<?> persistentClass, Map<Integer, Integer> outParameters, Object[] parameters) {
        super(jdbcBuilder);
        this.persistentClass = persistentClass;
        this.sql = sql;
        this.parameters = parameters;
        this.outParameters = outParameters;
    }

    @Override
    protected void prepare() {
    }

    @Override
    protected E doExecute() throws JdbcDataException {
        final HashMap procResult = new HashMap();
        this.jdbcBuilder.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                CallableStatement cs = con.prepareCall(ExecProcExecutor.this.sql);
                if (ExecProcExecutor.this.parameters != null) {
                    for (int i = 0; i < ExecProcExecutor.this.parameters.length; ++i) {
                        cs.setObject(i + 1, ExecProcExecutor.this.parameters[i]);
                    }
                }
                if (ExecProcExecutor.this.outParameters != null) {
                    for (Integer key : ExecProcExecutor.this.outParameters.keySet()) {
                        cs.registerOutParameter((int)key, (int)((Integer)ExecProcExecutor.this.outParameters.get(key)));
                    }
                }
                return cs;
            }
        }, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                cs.execute();
                if (ExecProcExecutor.this.outParameters != null) {
                    HashMap<Integer, Object> outParameterResult = new HashMap<Integer, Object>();
                    for (Integer key : ExecProcExecutor.this.outParameters.keySet()) {
                        outParameterResult.put(key, cs.getObject(key));
                    }
                    procResult.put("outParameters", outParameterResult);
                }
                procResult.put("updateCount", cs.getUpdateCount());
                ResultSet result = cs.getResultSet();
                ArrayList<Object> list = new ArrayList<Object>();
                if (result != null) {
                    Object rowMapper = null;
                    rowMapper = Map.class.isAssignableFrom(ExecProcExecutor.this.persistentClass) ? new ColumnMapRowMapper() : (String.class.equals((Object)ExecProcExecutor.this.persistentClass) || Integer.class.equals((Object)ExecProcExecutor.this.persistentClass) || Long.class.equals((Object)ExecProcExecutor.this.persistentClass) ? new SingleColumnRowMapper(ExecProcExecutor.this.persistentClass) : new BeanPropertyRowMapper(ExecProcExecutor.this.persistentClass));
                    int rowNum = 1;
                    while (result.next()) {
                        list.add(rowMapper.mapRow(result, rowNum++));
                    }
                    procResult.put("list", list);
                }
                return null;
            }
        });
        return (E)procResult;
    }
}

