/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.page;

import com.xphsc.easyjdbc.core.exception.EasyJdbcException;
import com.xphsc.easyjdbc.page.dialect.AbstractDialect;
import com.xphsc.easyjdbc.page.dialect.Db2Dialect;
import com.xphsc.easyjdbc.page.dialect.HerdDBDialect;
import com.xphsc.easyjdbc.page.dialect.HsqldbDialect;
import com.xphsc.easyjdbc.page.dialect.InformixDialect;
import com.xphsc.easyjdbc.page.dialect.MySqlDialect;
import com.xphsc.easyjdbc.page.dialect.OracleDialect;
import com.xphsc.easyjdbc.page.dialect.SqlServerDialect;
import java.util.HashMap;
import java.util.Map;

public class PageAutoDialect {
    private static Map<String, Class<?>> dialectAliasMap = new HashMap();
    private AbstractDialect delegate;
    private ThreadLocal<AbstractDialect> dialectThreadLocal = new ThreadLocal();
    private boolean autoDialect = true;

    public void initDelegateDialect(String dialectName) {
        if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.getDialect(dialectName);
            } else {
                this.dialectThreadLocal.set(this.getDialect(dialectName));
            }
        }
    }

    public static String dialect(String dialectName) {
        for (String dialect : dialectAliasMap.keySet()) {
            if (!dialectName.toLowerCase().equals(dialect)) continue;
            return dialect;
        }
        return null;
    }

    public AbstractDialect getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    private AbstractDialect initDialect(String dialectClass) {
        AbstractDialect dialect = null;
        try {
            Class sqlDialectClass = this.resloveDialectClass(dialectClass);
            if (AbstractDialect.class.isAssignableFrom(sqlDialectClass)) {
                dialect = (AbstractDialect)sqlDialectClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new EasyJdbcException("Initialization  [" + dialectClass + "]Error occurred:" + e.getMessage(), e);
        }
        return dialect;
    }

    private Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    private AbstractDialect getDialect(String dialectName) {
        String dialectStr = PageAutoDialect.dialect(dialectName);
        if (dialectStr == null) {
            throw new EasyJdbcException("Unable to automatically retrieve database type");
        }
        AbstractDialect dialect = this.initDialect(dialectStr);
        return dialect;
    }

    static {
        dialectAliasMap.put("hsqldb", HsqldbDialect.class);
        dialectAliasMap.put("h2", HsqldbDialect.class);
        dialectAliasMap.put("postgresql", HsqldbDialect.class);
        dialectAliasMap.put("mysql", MySqlDialect.class);
        dialectAliasMap.put("mariadb", MySqlDialect.class);
        dialectAliasMap.put("sqlite", MySqlDialect.class);
        dialectAliasMap.put("oracle", OracleDialect.class);
        dialectAliasMap.put("db2", Db2Dialect.class);
        dialectAliasMap.put("sqlserver", SqlServerDialect.class);
        dialectAliasMap.put("informix", InformixDialect.class);
        dialectAliasMap.put("phoenix", HsqldbDialect.class);
        dialectAliasMap.put("herddb", HerdDBDialect.class);
        dialectAliasMap.put("dm", OracleDialect.class);
        dialectAliasMap.put("edb", OracleDialect.class);
        dialectAliasMap.put("oscar", MySqlDialect.class);
        dialectAliasMap.put("clickhouse", MySqlDialect.class);
    }
}

