/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.util;

import com.xphsc.easyjdbc.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.objenesis.Objenesis;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

public class Jdbcs {
    private static final Objenesis OBJENESIS = new ObjenesisStd();
    private static final ConcurrentHashMap<String, ObjectInstantiator<?>> INSTANTIATORS = new ConcurrentHashMap();

    public static Set<Field> getFields(Class<?> cls, Set<Class<?>> superclass) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> type : superclass) {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
        }
        fields.addAll(Arrays.asList(cls.getDeclaredFields()));
        return Collections.unmodifiableSet(fields);
    }

    public static Method getReadMethod(Class<?> cls, Set<Class<?>> superclass, String fieldName, Class<?> ... parameterTypes) {
        HashSet classes = new HashSet();
        classes.add(cls);
        classes.addAll(superclass);
        String methodName = "get" + StringUtil.capitalize(fieldName);
        Method method = Jdbcs.getMethod(classes, methodName, parameterTypes);
        if (null == method) {
            methodName = "is" + StringUtil.capitalize(fieldName);
            method = Jdbcs.getMethod(classes, methodName, parameterTypes);
        }
        return method;
    }

    public static Method getWriteMethod(Class<?> cls, Set<Class<?>> superclass, String fieldName, Class<?> ... parameterTypes) {
        HashSet classes = new HashSet();
        classes.add(cls);
        classes.addAll(superclass);
        String methodName = "set" + StringUtil.capitalize(fieldName);
        return Jdbcs.getMethod(classes, methodName, parameterTypes);
    }

    public static Method getMethod(Set<Class<?>> classes, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> i : classes) {
            try {
                Method method = i.getDeclaredMethod(methodName, parameterTypes);
                if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, Method method, String errorMsg, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(errorMsg, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(errorMsg, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(errorMsg, e);
        }
    }

    public static <T> T newInstance(Class<?> cls) {
        if (cls.isInterface()) {
            throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684\u7c7b\u578b");
        }
        if (INSTANTIATORS.contains(cls.getName())) {
            return (T)INSTANTIATORS.get(cls.getName()).newInstance();
        }
        ObjectInstantiator instantiator = OBJENESIS.getInstantiatorOf(cls);
        INSTANTIATORS.putIfAbsent(cls.getName(), instantiator);
        return (T)instantiator.newInstance();
    }

    public static String camelToUnderline(String fieldName) {
        int len = fieldName.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_");
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

