/*
 * Copyright (c) 2019 huipei.x
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.xphsc.xpack.domain;

/**
 * @author <a href="xiongpeih@163.com">huipei.x</a>
 * @description:
 * @since 1.0.0
 */
public enum DockerGoalEnum {

    /**
     * 导出镜像到本地为 '.tar' 文件.
     */
    SAVE("save"),

    /**
     * 推送镜像到远程仓库中.
     */
    PUSH("push");

    /**
     * 代码值.
     */
    private String code;

    /**
     * 构造方法.
     *
     * @param code 代码值
     */
    DockerGoalEnum(String code) {
        this.code = code;
    }

    /**
     * 根据代码值的字符串找到对应的实例.
     *
     * @param codeStr 代码值字符串
     * @return DockerGoalEnum实例
     */
    public static DockerGoalEnum of(String codeStr) {
        for (DockerGoalEnum goalEnum : DockerGoalEnum.values()) {
            if (goalEnum.code.equalsIgnoreCase(codeStr)) {
                return goalEnum;
            }
        }
        return null;
    }

}
