/*
 * Copyright (c) 2019 huipei.x
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.xphsc.xpack.exception;

/**
 * @author <a href="xiongpeih@163.com">huipei.x</a>
 * @description:
 * @since 1.0.0
 */
public enum ExceptionEnum {

    /**
     * 没有 Docker 环境的枚举实例.
     */
    NO_DOCKER("未检测到或开启 Docker 环境."),

    /**
     * 没有 Dockerfile 文件的枚举实例.
     */
    NO_DOCKERFILE("Dockerfile 文件未找到！"),

    /**
     * 使用 xpack 构建 Docker 镜像出错的枚举实例.
     */
    DOCKER_BUILD_EXCEPTION("xpack 构建 Docker 镜像失败！"),

    /**
     * 使用 xpack 导出 Docker 镜像出错的枚举实例.
     */
    DOCKER_SAVE_EXCEPTION("xpack 导出 Docker 镜像失败！"),

    /**
     * 使用 xpack 对镜像打标签出错的枚举实例.
     */
    DOCKER_TAG_EXCEPTION("xpack 对镜像进行打标签失败！"),

    /**
     * 使用 xpack 推送 Docker 镜像出错的枚举实例.
     */
    DOCKER_PUSH_EXCEPTION("xpack 推送 Docker 镜像失败！");

    /**
     * 异常的描述信息.
     */
    private String msg;

    /**
     * 构造方法.
     *
     * @param msg 异常的描述信息
     */
    ExceptionEnum(String msg) {
        this.msg = msg;
    }

    /**
     * 获取异常的描述信息值.
     *
     * @return 描述信息
     */
    public String getMsg() {
        return this.msg;
    }

}
