/*
 * Copyright (c) 2019 huipei.x
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.xphsc.xpack.handler.impl;



import cn.xphsc.xpack.domain.PlatformEnum;
import cn.xphsc.xpack.domain.PackInfo;
import cn.xphsc.xpack.handler.AbstractPackHandler;
import cn.xphsc.xpack.utils.Logger;
import cn.xphsc.xpack.utils.Templates;

import java.io.File;
import java.io.IOException;
import java.util.Map;

/**
 * @author <a href="xiongpeih@163.com">huipei.x</a>
 * @description:
 * @since 1.0.0
 */
public class LinuxPackHandler extends AbstractPackHandler {

    /**
     * According to the relevant parameters of packaging, this Maven project is packaged into deployable packages in Linux.
     */
    @Override
    public void pack(PackInfo packInfo) {
        super.packInfo = packInfo;
        super.createPlatformCommonDir(PlatformEnum.LINUX);
        super.createBaseDirs();
        super.copyFiles("linux/README.md", "README.md");

        /**
         *  Render and write the corresponding resource file to the packaged folder where Linux is located.
          */

        this.renderShell();

        super.compress(PlatformEnum.LINUX);
    }


    private void renderShell() {
        Map<String, Object> context = super.buildBaseTemplateContextMap();

        String bin = super.binPath + File.separator;
        try {
            Templates.renderFile("linux/bin/start.sh", context, bin + "start.sh");
            Templates.renderFile("linux/bin/stop.sh", context, bin + "stop.sh");
            Templates.renderFile("linux/bin/restart.sh", context, bin + "restart.sh");
        } catch (IOException e) {
            Logger.error("渲染 shell 模板内容并写入 bin 目录中出错！", e);
        }
    }

}
