/*
 * Copyright (c) 2019 huipei.x
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.xphsc.xpack.handler.impl;



import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import cn.xphsc.xpack.domain.PlatformEnum;
import cn.xphsc.xpack.domain.PackInfo;
import cn.xphsc.xpack.handler.AbstractPackHandler;
import cn.xphsc.xpack.utils.Logger;
import cn.xphsc.xpack.utils.Templates;
import org.apache.commons.lang3.StringUtils;

/**
 * @author <a href="xiongpeih@163.com">huipei.x</a>
 * @description:
 * @since 1.0.0
 */
public class WindowsPackHandler extends AbstractPackHandler {


    private static final String[] BAT_NAME_ARR = {"install", "uninstall", "start", "stop", "restart"};

    /**
     *
     According to the relevant parameters of packaging, this Maven project is packaged into deployable packages in Windows.
     */
    @Override
    public void pack(PackInfo packInfo) {
        super.packInfo = packInfo;
        super.createPlatformCommonDir(PlatformEnum.WINDOWS);
        super.createBaseDirs();

        super.copyFiles("windows/README.md", "README.md");
        String projectName = BIN_DIR_NAME + File.separator +(packInfo.isNameVersion()?packInfo.getName():packInfo.getArtifactId());
        this.renderWinswXml(super.platformPath + File.separator + projectName + ".xml", packInfo);
        super.copyFiles("windows/bin/winsw.exe", projectName + ".exe");
        super.copyFiles("windows/bin/winsw.exe.config", projectName + ".exe.config");

        // Create all `bat'files.
        this.createAllBatFiles((packInfo.isNameVersion()?packInfo.getName():packInfo.getArtifactId()));

        // Making. zip compression package.
        super.compress(PlatformEnum.WINDOWS);
    }


    private void renderWinswXml(String destXml, PackInfo packInfo) {
        Map<String, Object> context = new HashMap<>(8);
        context.put("projectId", packInfo.getArtifactId());
        context.put("name", (packInfo.isNameVersion()?packInfo.getName():packInfo.getArtifactId()));
        context.put("description", packInfo.getDescription());

        String vmOptions = StringUtils.isBlank(packInfo.getVmOptions()) ? "" : packInfo.getVmOptions() + " ";
        String args = StringUtils.isBlank(packInfo.getProgramArgs()) ? "" : " " + packInfo.getProgramArgs();

        context.put("arguments", vmOptions + "-jar ..\\" + (packInfo.isNameVersion()?packInfo.getFullJarName():packInfo.getArtifactId()+PackInfo.getJAR()) + args);

        try {
            Templates.renderFile("windows/bin/winsw.xml", context, destXml);
        } catch (IOException e) {
            Logger.error("渲染 winsw.xml 模板内容并写入 bin 目录中出错！", e);
        }
    }


    private void createAllBatFiles(String name) {
        try {
            for (String batName : BAT_NAME_ARR) {

                Map<String, Object> context = new HashMap<>(4);
                context.put("name", name);
                context.put("batName", batName);

                // Render the template of. bat and write the result to bin directory to generate files such as: install. bat, start. bat, etc.
                Templates.renderFile("windows/bin/template.bat", context,
                        super.binPath + batName + ".bat");
            }
        } catch (IOException e) {
            Logger.error("渲染 template.bat 模板内容并写入到 bin 目录中出错！", e);
        }
    }

}
